/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.mapped.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.ad.mapped.impl.SourceValue;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueMap
implements Function<String, Set<StringAttributeValue>> {
    private final Logger log = LoggerFactory.getLogger(ValueMap.class);
    private String returnValue;
    @Nonnull
    @NonnullElements
    private Collection<SourceValue> sourceValues = Collections.emptySet();

    @Nullable
    public String getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(@Nonnull @NotEmpty String newReturnValue) {
        this.returnValue = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)newReturnValue), (String)"ReturnValue must be non null or empty");
    }

    public void setSourceValues(@Nullable @NullableElements Collection<SourceValue> newValues) {
        this.sourceValues = ImmutableSet.copyOf((Iterable)Iterables.filter(newValues, (Predicate)Predicates.notNull()));
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Collection<SourceValue> getSourceValues() {
        return this.sourceValues;
    }

    @Nullable
    public Set<StringAttributeValue> apply(@Nullable String attributeValue) {
        if (attributeValue == null) {
            this.log.debug("Input value was null, returning empty set");
            return Collections.emptySet();
        }
        this.log.debug("Attempting to map attribute value '{}'", (Object)attributeValue);
        HashSet<StringAttributeValue> mappedValues = new HashSet<StringAttributeValue>();
        for (SourceValue sourceValue : this.sourceValues) {
            String newValue = null;
            if (sourceValue.isPartialMatch()) {
                this.log.debug("Performing partial match comparison");
                if (sourceValue.getValue() == null) {
                    this.log.debug("Source value was null, no partial match");
                } else if (attributeValue.contains(sourceValue.getValue())) {
                    newValue = this.returnValue;
                    this.log.debug("Attribute value '{}' contains source value '{}', will be mapped to '{}'", new Object[]{attributeValue, sourceValue.getValue(), newValue});
                }
            } else {
                this.log.debug("Performing regular expression based comparison");
                try {
                    Matcher m = sourceValue.getPattern().matcher(attributeValue);
                    if (m.matches()) {
                        newValue = this.returnValue != null ? m.replaceAll(this.returnValue) : null;
                        this.log.debug("Attribute value '{}' matches regular expression, will be mapped to '{}'", (Object)attributeValue, (Object)newValue);
                    }
                }
                catch (PatternSyntaxException e) {
                    this.log.debug("Error matching value '{}', skipping it", (Object)attributeValue);
                }
            }
            if (newValue == null) continue;
            mappedValues.add(new StringAttributeValue(newValue));
        }
        return mappedValues;
    }
}

