/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.http.impl;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.dc.ValidationException;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.idp.attribute.resolver.dc.http.impl.HTTPResponseMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.http.impl.HTTPSearch;
import net.shibboleth.idp.attribute.resolver.dc.impl.AbstractSearchDataConnector;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.http.client.HttpClient;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPDataConnector
extends AbstractSearchDataConnector<HTTPSearch, HTTPResponseMappingStrategy> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPDataConnector.class);
    @NonnullAfterInit
    private HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;

    public HTTPDataConnector() {
        this.setValidator(new Validator(){

            public void validate() throws ValidationException {
            }
        });
    }

    public void setHttpClient(@Nonnull HttpClient client) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.httpClientSecurityParameters = params;
    }

    @Override
    public void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpClient == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " HttpClient cannot be null");
        }
    }

    @Override
    @Nullable
    protected Map<String, IdPAttribute> retrieveAttributes(@Nonnull HTTPSearch executable) throws ResolutionException {
        try {
            return ((HTTPResponseMappingStrategy)this.getMappingStrategy()).map(executable.execute(this.httpClient, this.httpClientSecurityParameters, (HTTPResponseMappingStrategy)this.getMappingStrategy()));
        }
        catch (IOException e) {
            throw new ResolutionException(this.getLogPrefix() + " HTTP request failed", (Exception)e);
        }
    }
}

