/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.rdbms.impl;

import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import net.shibboleth.idp.attribute.resolver.dc.ValidationException;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceValidator
extends AbstractInitializableComponent
implements Validator {
    private final Logger log = LoggerFactory.getLogger(DataSourceValidator.class);
    @NonnullAfterInit
    private DataSource dataSource;
    private boolean throwOnValidateError = true;

    @Deprecated
    public DataSourceValidator(DataSource source) {
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"DataSourceValidator(DataSource)", null, (String)"DataSourceValidator()");
        this.dataSource = source;
        try {
            this.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new ConstraintViolationException("Invalid parameterization.");
        }
    }

    @Deprecated
    public DataSourceValidator(DataSource source, boolean throwOnError) {
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"DataSourceValidator(DataSource, boolean)", null, (String)"DataSourceValidator()");
        this.dataSource = source;
        this.throwOnValidateError = throwOnError;
        try {
            this.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new ConstraintViolationException("Invalid parameterization.");
        }
    }

    public DataSourceValidator() {
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.dataSource) {
            throw new ComponentInitializationException("DataSourceValidator: Data Source should not be null");
        }
    }

    public void setDataSource(@Nonnull DataSource source) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dataSource = (DataSource)Constraint.isNotNull((Object)source, (String)"Data Source should not be null");
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setThrowValidateError(boolean value) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.throwOnValidateError = value;
    }

    public boolean isThrowValidateError() {
        return this.throwOnValidateError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void validate() throws ValidationException {
        block16: {
            Connection connection;
            block15: {
                ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
                connection = null;
                connection = this.dataSource.getConnection();
                if (connection != null) break block15;
                this.log.error("Unable to retrieve connections from configured data source");
                if (!this.throwOnValidateError) break block15;
                throw new ValidationException("Unable to retrieve connections from configured data source");
            }
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
                break block16;
            }
            catch (SQLException e) {
                this.log.error("Error closing database connection; SQL State: {}, SQL Code: {}", new Object[]{e.getSQLState(), e.getErrorCode(), e});
            }
            break block16;
            catch (SQLException e) {
                block17: {
                    try {
                        if (e.getSQLState() != null) {
                            this.log.error("Datasource validation failed with SQL state: {}, SQL Code: {}", new Object[]{e.getSQLState(), e.getErrorCode(), e});
                        } else {
                            this.log.error("Datasource validation failed", (Throwable)e);
                        }
                        if (!this.throwOnValidateError) break block17;
                        throw new ValidationException("Invalid connector configuration", (Exception)e);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (connection != null && !connection.isClosed()) {
                                connection.close();
                            }
                        }
                        catch (SQLException e2) {
                            this.log.error("Error closing database connection; SQL State: {}, SQL Code: {}", new Object[]{e2.getSQLState(), e2.getErrorCode(), e2});
                        }
                        throw throwable;
                    }
                }
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
                catch (SQLException e3) {
                    this.log.error("Error closing database connection; SQL State: {}, SQL Code: {}", new Object[]{e3.getSQLState(), e3.getErrorCode(), e3});
                }
            }
        }
    }
}

