/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.rdbms.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.dc.ValidationException;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.idp.attribute.resolver.dc.impl.AbstractSearchDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.DataSourceValidator;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.ExecutableStatement;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.ResultMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.StringResultMappingStrategy;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBMSDataConnector
extends AbstractSearchDataConnector<ExecutableStatement, ResultMappingStrategy> {
    private final Logger log = LoggerFactory.getLogger(RDBMSDataConnector.class);
    private DataSource dataSource;
    private boolean readOnlyConnection = true;
    private boolean defaultValidator = true;
    private boolean defaultMappingStrategy = true;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(@Nonnull DataSource source) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.dataSource = (DataSource)Constraint.isNotNull((Object)source, (String)"JDBC data source can not be null");
    }

    public boolean isConnectionReadOnly() {
        return this.readOnlyConnection;
    }

    public void setConnectionReadOnly(boolean isReadOnly) {
        this.readOnlyConnection = isReadOnly;
    }

    @Override
    public void setValidator(@Nonnull Validator validator) {
        super.setValidator(validator);
        this.defaultValidator = false;
    }

    @Override
    public void setMappingStrategy(@Nonnull ResultMappingStrategy strategy) {
        super.setMappingStrategy(strategy);
        this.defaultMappingStrategy = false;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        if (this.dataSource == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " no data source was configured");
        }
        if (this.defaultValidator) {
            DataSourceValidator validator = new DataSourceValidator();
            validator.setDataSource(this.dataSource);
            validator.initialize();
            super.setValidator(validator);
        }
        if (this.defaultMappingStrategy) {
            super.setMappingStrategy(new StringResultMappingStrategy());
        }
        super.doInitialize();
        try {
            this.getValidator().validate();
        }
        catch (ValidationException e) {
            this.log.error("{} Invalid connector configuration", (Object)this.getLogPrefix(), (Object)e);
            throw new ComponentInitializationException(this.getLogPrefix() + " Invalid connector configuration", (Exception)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    protected Map<String, IdPAttribute> retrieveAttributes(ExecutableStatement statement) throws ResolutionException {
        Map map;
        if (statement == null) {
            throw new ResolutionException("Executable statement cannot be null");
        }
        Connection connection = null;
        ResultSet queryResult = null;
        try {
            connection = this.dataSource.getConnection();
            if (this.readOnlyConnection) {
                connection.setReadOnly(true);
            }
            queryResult = statement.execute(connection);
            this.log.trace("Data connector '{}': search returned {}", (Object)this.getId(), (Object)queryResult);
            map = ((ResultMappingStrategy)this.getMappingStrategy()).map(queryResult);
        }
        catch (SQLException e) {
            try {
                throw new ResolutionException(this.getLogPrefix() + " Unable to execute SQL query", (Exception)e);
            }
            catch (Throwable throwable) {
                try {
                    if (queryResult != null) {
                        queryResult.close();
                    }
                    if (connection == null) throw throwable;
                    if (connection.isClosed()) throw throwable;
                    connection.close();
                    throw throwable;
                }
                catch (SQLException e2) {
                    this.log.debug("{} Unable to close database connection; SQL State: {}, SQL Code: {}", (Object)new Object[]{this.getLogPrefix(), e2.getSQLState(), e2.getErrorCode()}, (Object)e2);
                }
                throw throwable;
            }
        }
        try {
            if (queryResult != null) {
                queryResult.close();
            }
            if (connection == null) return map;
            if (connection.isClosed()) return map;
            connection.close();
            return map;
        }
        catch (SQLException e) {
            this.log.debug("{} Unable to close database connection; SQL State: {}, SQL Code: {}", (Object)new Object[]{this.getLogPrefix(), e.getSQLState(), e.getErrorCode()}, (Object)e);
        }
        return map;
    }
}

