/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.http.impl;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.http.impl.HTTPResponseMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.http.impl.HTTPSearch;
import net.shibboleth.idp.attribute.resolver.dc.impl.ExecutableSearchBuilder;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;

public abstract class AbstractHTTPSearchBuilder
extends AbstractInitializableComponent
implements ExecutableSearchBuilder<HTTPSearch> {
    @Nonnull
    @NonnullElements
    private Map<String, String> headerMap = Collections.emptyMap();
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Map<String, String> getHeaders() {
        return ImmutableMap.copyOf(this.headerMap);
    }

    public void setHeaders(@Nonnull @NonnullElements Map<String, String> headers) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull(headers, (String)"Map of headers cannot be null");
        this.headerMap = new HashMap<String, String>(headers.size());
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = StringSupport.trimOrNull((String)entry.getKey());
            String value = StringSupport.trimOrNull((String)entry.getValue());
            if (key == null || value == null) continue;
            this.headerMap.put(key, value);
        }
    }

    @Nullable
    public HttpClientSecurityParameters getHttpClientSecurityParameters() {
        return this.httpClientSecurityParameters;
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.httpClientSecurityParameters = params;
    }

    @Override
    public HTTPSearch build(final @Nonnull AttributeResolutionContext resolutionContext, final @Nonnull Map<String, List<IdPAttributeValue<?>>> dependencyAttributes) throws ResolutionException {
        final HttpUriRequest request = this.getHttpRequest(resolutionContext, dependencyAttributes);
        for (Map.Entry<String, String> entry : this.headerMap.entrySet()) {
            request.setHeader(entry.getKey(), entry.getValue());
        }
        return new HTTPSearch(){

            @Override
            @Nullable
            public String getResultCacheKey() {
                return AbstractHTTPSearchBuilder.this.getResultCacheKey(request, resolutionContext, dependencyAttributes);
            }

            public String toString() {
                return request.getRequestLine().getUri();
            }

            @Override
            @Nonnull
            public Map<String, IdPAttribute> execute(@Nonnull HttpClient client, @Nullable HttpClientSecurityParameters securityParameters, @Nonnull HTTPResponseMappingStrategy mappingStrategy) throws IOException {
                HttpClientContext clientContext = HttpClientContext.create();
                HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)clientContext, (HttpClientSecurityParameters)securityParameters, (boolean)true);
                HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)clientContext, (HttpUriRequest)request);
                Map results = (Map)client.execute(request, (ResponseHandler)mappingStrategy, (HttpContext)clientContext);
                HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)clientContext, (String)request.getURI().getScheme());
                return results;
            }
        };
    }

    @Nonnull
    @NotEmpty
    protected String getURL(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue<?>>> dependencyAttributes) throws ResolutionException {
        throw new UnsupportedOperationException("getURL method not overridden by subclass");
    }

    @Nonnull
    protected HttpUriRequest getHttpRequest(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue<?>>> dependencyAttributes) throws ResolutionException {
        try {
            return new HttpGet(this.getURL(resolutionContext, dependencyAttributes));
        }
        catch (IllegalArgumentException e) {
            throw new ResolutionException((Exception)e);
        }
    }

    @Nullable
    protected String getResultCacheKey(@Nonnull HttpUriRequest request, @Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue<?>>> dependencyAttributes) {
        if (request instanceof HttpGet) {
            return ((HttpGet)request).getURI().toString();
        }
        return null;
    }
}

