/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.http.impl;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.google.common.xml.XmlEscapers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.http.impl.AbstractHTTPSearchBuilder;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.velocity.Template;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplatedBodyBuilder
extends AbstractHTTPSearchBuilder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TemplatedBodyBuilder.class);
    @NonnullAfterInit
    private Template urlTemplate;
    @NonnullAfterInit
    private Template bodyTemplate;
    @NonnullAfterInit
    private Template cacheKeyTemplate;
    @NonnullAfterInit
    private String urlTemplateText;
    @NonnullAfterInit
    private String bodyTemplateText;
    @NonnullAfterInit
    private String cacheKeyTemplateText;
    @NonnullAfterInit
    private VelocityEngine engine;
    @Nonnull
    @NotEmpty
    private String method = "POST";
    @Nonnull
    @NotEmpty
    private String mimeType = "text/plain";
    @Nullable
    private String charset;
    @NonnullAfterInit
    private ContentType contentType;
    @Nonnull
    private final Escaper paramEscaper = UrlEscapers.urlFormParameterEscaper();
    @Nonnull
    private final Escaper fragmentEscaper = UrlEscapers.urlFragmentEscaper();
    @Nonnull
    private final Escaper pathEscaper = UrlEscapers.urlPathSegmentEscaper();
    @Nonnull
    private final Escaper xmlAttributeEscaper = XmlEscapers.xmlAttributeEscaper();
    @Nonnull
    private final Escaper xmlContentEscaper = XmlEscapers.xmlContentEscaper();
    @Nullable
    private Object customObject;

    @NonnullAfterInit
    public Template getURLTemplate() {
        return this.urlTemplate;
    }

    @NonnullAfterInit
    public Template getBodyTemplate() {
        return this.bodyTemplate;
    }

    @Nullable
    public Template getCacheKeyTemplate() {
        return this.cacheKeyTemplate;
    }

    @NonnullAfterInit
    public String getURLTemplateText() {
        return this.urlTemplateText;
    }

    public void setURLTemplateText(@Nullable String text) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.urlTemplateText = StringSupport.trimOrNull((String)text);
    }

    @NonnullAfterInit
    public String getBodyTemplateText() {
        return this.bodyTemplateText;
    }

    public void setBodyTemplateText(@Nullable String text) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.bodyTemplateText = StringSupport.trimOrNull((String)text);
    }

    @Nullable
    public String getCacheKeyTemplateText() {
        return this.cacheKeyTemplateText;
    }

    public void setCacheKeyTemplateText(@Nullable String text) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.cacheKeyTemplateText = StringSupport.trimOrNull((String)text);
    }

    @NonnullAfterInit
    public VelocityEngine getVelocityEngine() {
        return this.engine;
    }

    public void setVelocityEngine(@Nonnull VelocityEngine velocityEngine) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.engine = (VelocityEngine)Constraint.isNotNull((Object)velocityEngine, (String)"Velocity engine cannot be null");
    }

    public void setMethod(@Nonnull @NotEmpty String m) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.method = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)m), (String)"HTTP method cannot be null or empty");
        Constraint.isTrue(("POST".equals(this.method) || "PUT".equals(this.method) ? 1 : 0) != 0, (String)"HTTP method must be POST or PUT");
    }

    public void setMIMEType(@Nonnull @NotEmpty String type) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.mimeType = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)type), (String)"MIME type cannot be null or empty");
    }

    public void setCharacterSet(@Nullable String c) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.charset = StringSupport.trimOrNull((String)c);
    }

    public void setCustomObject(@Nullable Object object) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.customObject = object;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.engine) {
            throw new ComponentInitializationException("Velocity engine cannot be null");
        }
        if (null == this.urlTemplateText) {
            throw new ComponentInitializationException("URL template text cannot be null");
        }
        if (null == this.bodyTemplateText) {
            throw new ComponentInitializationException("Body template text cannot be null");
        }
        this.urlTemplate = Template.fromTemplate((VelocityEngine)this.engine, (String)this.urlTemplateText);
        this.bodyTemplate = Template.fromTemplate((VelocityEngine)this.engine, (String)this.bodyTemplateText);
        if (null != this.cacheKeyTemplateText) {
            this.cacheKeyTemplate = Template.fromTemplate((VelocityEngine)this.engine, (String)this.cacheKeyTemplateText);
        }
        this.contentType = ContentType.create((String)this.mimeType, (String)this.charset);
    }

    @Nonnull
    @NotEmpty
    protected String merge(@Nonnull Template template, @Nonnull VelocityContext context) {
        return template.merge((Context)context);
    }

    @Override
    @Nonnull
    protected HttpUriRequest getHttpRequest(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue<?>>> dependencyAttributes) throws ResolutionException {
        HttpPost request;
        String body;
        String url;
        VelocityContext context = new VelocityContext();
        this.log.trace("Creating request using attribute resolution context {}", (Object)resolutionContext);
        context.put("resolutionContext", (Object)resolutionContext);
        context.put("httpClientSecurityParameters", (Object)this.getHttpClientSecurityParameters());
        context.put("paramEscaper", (Object)this.paramEscaper);
        context.put("fragmentEscaper", (Object)this.fragmentEscaper);
        context.put("pathEscaper", (Object)this.pathEscaper);
        context.put("xmlAttributeEscaper", (Object)this.xmlAttributeEscaper);
        context.put("xmlContentEscaper", (Object)this.xmlContentEscaper);
        context.put("custom", this.customObject);
        if (dependencyAttributes != null && !dependencyAttributes.isEmpty()) {
            for (Map.Entry<String, List<IdPAttributeValue<?>>> entry : dependencyAttributes.entrySet()) {
                ArrayList<Object> values = new ArrayList<Object>(entry.getValue().size());
                for (IdPAttributeValue<?> value : entry.getValue()) {
                    values.add(value.getValue());
                }
                this.log.trace("Adding dependency {} to context with {} value(s)", (Object)entry.getKey(), (Object)values.size());
                context.put(entry.getKey(), values);
            }
        }
        try {
            url = this.merge(this.urlTemplate, context);
            body = this.merge(this.bodyTemplate, context);
        }
        catch (VelocityException e) {
            this.log.error("Error running template engine", (Throwable)e);
            throw new ResolutionException("Error running template engine", (Exception)((Object)e));
        }
        try {
            if ("POST".equals(this.method)) {
                request = new HttpPost(url);
            } else if ("PUT".equals(this.method)) {
                request = new HttpPut(url);
            } else {
                throw new ResolutionException("Unsupported HTTP method");
            }
            request.setEntity((HttpEntity)new StringEntity(body, this.contentType));
        }
        catch (IllegalArgumentException e) {
            throw new ResolutionException((Exception)e);
        }
        return request;
    }

    @Override
    @Nonnull
    @NotEmpty
    protected String getResultCacheKey(@Nonnull HttpUriRequest request, @Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue<?>>> dependencyAttributes) {
        if (this.cacheKeyTemplate == null) {
            return null;
        }
        VelocityContext context = new VelocityContext();
        this.log.trace("Creating cache key using attribute resolution context {}", (Object)resolutionContext);
        context.put("resolutionContext", (Object)resolutionContext);
        context.put("httpClientSecurityParameters", (Object)this.getHttpClientSecurityParameters());
        if (dependencyAttributes != null && !dependencyAttributes.isEmpty()) {
            for (Map.Entry<String, List<IdPAttributeValue<?>>> entry : dependencyAttributes.entrySet()) {
                ArrayList<Object> values = new ArrayList<Object>(entry.getValue().size());
                for (IdPAttributeValue<?> value : entry.getValue()) {
                    values.add(value.getValue());
                }
                this.log.trace("Adding dependency {} to context with {} value(s)", (Object)entry.getKey(), (Object)values.size());
                context.put(entry.getKey(), values);
            }
        }
        return this.merge(this.cacheKeyTemplate, context);
    }
}

