/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.impl;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ad.impl.DelegatedWorkContext;
import net.shibboleth.idp.attribute.resolver.ad.impl.ScriptedIdPAttributeImpl;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.scripting.AbstractScriptEvaluator;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptedDataConnector
extends AbstractDataConnector {
    @Nonnull
    public static final String RESULTS_STRING = "connectorResults";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedDataConnector.class);
    @NonnullAfterInit
    private EvaluableScript script;
    @NonnullAfterInit
    private DataConnectorScriptEvaluator scriptEvaluator;
    @Nonnull
    private Function<AttributeResolutionContext, ProfileRequestContext> prcLookupStrategy = new ParentContextLookup();
    @Nonnull
    private Function<ProfileRequestContext, SubjectContext> scLookupStrategy = new ChildContextLookup(SubjectContext.class);
    @Nullable
    private Object customObject;

    @Nullable
    public Object getCustomObject() {
        return this.customObject;
    }

    @Nullable
    public void setCustomObject(Object object) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.customObject = object;
    }

    @NonnullAfterInit
    public EvaluableScript getScript() {
        return this.script;
    }

    public void setScript(@Nonnull EvaluableScript definitionScript) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.script = (EvaluableScript)Constraint.isNotNull((Object)definitionScript, (String)"Attribute definition script cannot be null");
    }

    public void setProfileRequestContextLookupStrategy(@Nonnull Function<AttributeResolutionContext, ProfileRequestContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.prcLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileRequestContext lookup strategy cannot be null");
    }

    public void setSubjectContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SubjectContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.scLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.script) {
            throw new ComponentInitializationException(this.getLogPrefix() + ": No script supplied");
        }
        this.scriptEvaluator = new DataConnectorScriptEvaluator(this.script);
        this.scriptEvaluator.setCustomObject(this.customObject);
        this.scriptEvaluator.setLogPrefix(this.getLogPrefix());
    }

    @Nullable
    protected Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        Constraint.isNotNull((Object)resolutionContext, (String)"AttributeResolutionContext cannot be null");
        Constraint.isNotNull((Object)workContext, (String)"AttributeResolverWorkContext cannot be null");
        return this.scriptEvaluator.execute(resolutionContext, workContext);
    }

    private class DataConnectorScriptEvaluator
    extends AbstractScriptEvaluator {
        public DataConnectorScriptEvaluator(EvaluableScript theScript) {
            super(theScript);
        }

        @Nullable
        protected Map<String, IdPAttribute> execute(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
            try {
                return (Map)this.evaluate(new Object[]{resolutionContext, workContext});
            }
            catch (RuntimeException e) {
                throw new ResolutionException(this.getLogPrefix() + "Script did not run successfully", (Exception)e);
            }
        }

        protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
            ScriptedDataConnector.this.log.debug("{} Adding to-be-populated attribute set '{}' to script context", (Object)this.getLogPrefix(), (Object)ScriptedDataConnector.RESULTS_STRING);
            scriptContext.setAttribute(ScriptedDataConnector.RESULTS_STRING, new HashSet(), 100);
            ScriptedDataConnector.this.log.debug("{} Adding current attribute resolution contexts to script context", (Object)this.getLogPrefix());
            scriptContext.setAttribute("resolutionContext", input[0], 100);
            scriptContext.setAttribute("workContext", (Object)new DelegatedWorkContext((AttributeResolverWorkContext)input[1], this.getLogPrefix()), 100);
            ProfileRequestContext prc = (ProfileRequestContext)ScriptedDataConnector.this.prcLookupStrategy.apply((Object)((AttributeResolutionContext)input[0]));
            if (null == prc) {
                ScriptedDataConnector.this.log.error("{} ProfileRequestContext could not be located", (Object)this.getLogPrefix());
            }
            scriptContext.setAttribute("profileContext", prc, 100);
            SubjectContext sc = (SubjectContext)ScriptedDataConnector.this.scLookupStrategy.apply((Object)prc);
            if (null == sc) {
                ScriptedDataConnector.this.log.warn("{} Could not locate SubjectContext", (Object)this.getLogPrefix());
            } else {
                List subjects = sc.getSubjects();
                if (null == subjects) {
                    ScriptedDataConnector.this.log.warn("{} Could not locate Subjects", (Object)this.getLogPrefix());
                } else {
                    scriptContext.setAttribute("subjects", subjects.toArray(new Subject[subjects.size()]), 100);
                }
            }
            Map dependencyAttributes = PluginDependencySupport.getAllAttributeValues((AttributeResolverWorkContext)((AttributeResolverWorkContext)input[1]), (Collection)ScriptedDataConnector.this.getDependencies());
            for (Map.Entry dependencyAttribute : dependencyAttributes.entrySet()) {
                ScriptedDataConnector.this.log.trace("{} Adding dependent attribute '{}' with the following values to the script context: {}", new Object[]{this.getLogPrefix(), dependencyAttribute.getKey(), dependencyAttribute.getValue()});
                IdPAttribute pseudoAttribute = new IdPAttribute((String)dependencyAttribute.getKey());
                pseudoAttribute.setValues((Collection)dependencyAttribute.getValue());
                scriptContext.setAttribute((String)dependencyAttribute.getKey(), new ScriptedIdPAttributeImpl(pseudoAttribute, this.getLogPrefix()), 100);
            }
        }

        @Nullable
        protected Object finalizeContext(@Nonnull ScriptContext scriptContext, @Nullable Object scriptResult) throws ScriptException {
            Object res = scriptContext.getAttribute(ScriptedDataConnector.RESULTS_STRING);
            if (null == res) {
                ScriptedDataConnector.this.log.error("{} Could not locate output variable '{}' from script", (Object)this.getLogPrefix(), (Object)ScriptedDataConnector.RESULTS_STRING);
                throw new ScriptException("Could not locate output from script");
            }
            if (!(res instanceof Collection)) {
                ScriptedDataConnector.this.log.error("{} Output '{}' was of type '{}', expected '{}'", new Object[]{this.getLogPrefix(), res.getClass().getName(), Collection.class.getName()});
                throw new ScriptException("Output was of the wrong type");
            }
            Collection outputCollection = (Collection)res;
            HashMap<String, IdPAttribute> outputMap = new HashMap<String, IdPAttribute>(outputCollection.size());
            for (Object o : outputCollection) {
                if (o instanceof IdPAttribute) {
                    IdPAttribute attribute = (IdPAttribute)o;
                    if (null == attribute.getId()) {
                        ScriptedDataConnector.this.log.warn("{} Anonymous Attribute encountered, ignored", (Object)this.getLogPrefix());
                        continue;
                    }
                    this.checkValues(attribute);
                    outputMap.put(attribute.getId(), attribute);
                    continue;
                }
                ScriptedDataConnector.this.log.warn("{} Output collection contained an object of type '{}', ignored", (Object)this.getLogPrefix(), (Object)o.getClass().getName());
            }
            return outputMap;
        }

        private void checkValues(IdPAttribute attribute) {
            if (null == attribute.getValues()) {
                ScriptedDataConnector.this.log.info("{} Attribute '{}' has no values provided.", (Object)this.getLogPrefix(), (Object)attribute.getId());
                attribute.setValues(Collections.emptyList());
                return;
            }
            ScriptedDataConnector.this.log.debug("{} Attribute '{}' has {} value(s).", new Object[]{this.getLogPrefix(), attribute.getId(), attribute.getValues().size()});
            List inputValues = attribute.getValues();
            ArrayList<IdPAttributeValue> outputValues = new ArrayList<IdPAttributeValue>(inputValues.size());
            for (Object o : inputValues) {
                if (o instanceof IdPAttributeValue) {
                    outputValues.add((IdPAttributeValue)o);
                    continue;
                }
                ScriptedDataConnector.this.log.error("{} Attribute '{} has attribute value of type {}.  This will be ignored", new Object[]{this.getLogPrefix(), attribute.getId(), o.getClass().getName()});
            }
            attribute.setValues(outputValues);
        }
    }
}

