/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.impl;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class StaticDataConnector
extends AbstractDataConnector {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StaticDataConnector.class);
    private Map<String, IdPAttribute> attributes;

    @Nullable
    @NonnullAfterInit
    public Map<String, IdPAttribute> getAttributes() {
        return this.attributes;
    }

    public void setValues(@Nullable @NullableElements Collection<IdPAttribute> newValues) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        if (null == newValues) {
            this.attributes = null;
            return;
        }
        HashMap<String, IdPAttribute> map = new HashMap<String, IdPAttribute>(newValues.size());
        for (IdPAttribute attr : newValues) {
            if (null == attr) continue;
            map.put(attr.getId(), attr);
        }
        this.attributes = ImmutableMap.copyOf(map);
    }

    @Nonnull
    protected Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.log.trace("{} Resolved attributes: {}", (Object)this.getLogPrefix(), this.attributes);
        return this.attributes;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.attributes) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No values set up.");
        }
    }
}

