/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.ldap.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.resolver.dc.impl.ExecutableSearchBuilder;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.ExecutableSearchFilter;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.SearchExecutor;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExecutableSearchFilterBuilder
extends AbstractInitializableComponent
implements ExecutableSearchBuilder<ExecutableSearchFilter> {
    private final Logger log = LoggerFactory.getLogger(AbstractExecutableSearchFilterBuilder.class);

    protected ExecutableSearchFilter build(final @Nonnull SearchFilter searchFilter) {
        return new ExecutableSearchFilter(){

            @Override
            @Nullable
            public String getResultCacheKey() {
                return searchFilter.format();
            }

            @Override
            @Nonnull
            public SearchResult execute(@Nonnull SearchExecutor executor, @Nonnull ConnectionFactory factory) throws LdapException {
                Response response = executor.search(factory, searchFilter);
                AbstractExecutableSearchFilterBuilder.this.log.trace("Search returned response {}", (Object)response);
                return (SearchResult)response.getResult();
            }

            @Override
            @Nonnull
            public SearchFilter getSearchFilter() {
                return searchFilter;
            }

            public String toString() {
                return searchFilter.toString();
            }
        };
    }
}

