/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.impl;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.ext.spring.service.AbstractServiceableComponent;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.DataConnectorEx;
import net.shibboleth.idp.attribute.resolver.LegacyPrincipalDecoder;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolvedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ResolverAttributeDefinitionDependency;
import net.shibboleth.idp.attribute.resolver.ResolverDataConnectorDependency;
import net.shibboleth.idp.attribute.resolver.ResolverPlugin;
import net.shibboleth.idp.attribute.resolver.ResolverPluginDependency;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.collection.LazyList;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.profile.context.MetricContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AttributeResolverImpl
extends AbstractServiceableComponent<AttributeResolver>
implements AttributeResolver,
LegacyPrincipalDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeResolverImpl.class);
    @NonnullAfterInit
    private Map<String, AttributeDefinition> attributeDefinitions;
    @NonnullAfterInit
    private Map<String, DataConnector> dataConnectors;
    @NonnullAfterInit
    private String logPrefix;
    @Nullable
    private LegacyPrincipalDecoder principalConnector;
    private boolean stripNulls;
    @Nonnull
    private Function<AttributeResolutionContext, ProfileRequestContext> profileContextStrategy = new ParentContextLookup();

    public void setId(@Nonnull @NotEmpty String resolverId) {
        super.setId(resolverId);
    }

    public void setAttributeDefinitions(@Nullable @NullableElements Collection<AttributeDefinition> definitions) {
        Map<String, AttributeDefinition> checkedDefinitions;
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (definitions != null) {
            checkedDefinitions = new HashMap(definitions.size());
            for (AttributeDefinition definition : definitions) {
                if (definition == null) continue;
                if (checkedDefinitions.containsKey(definition.getId())) {
                    throw new IllegalArgumentException(this.logPrefix + " Duplicate Attribute Definition with id '" + definition.getId() + "'");
                }
                checkedDefinitions.put(definition.getId(), definition);
            }
        } else {
            checkedDefinitions = Collections.emptyMap();
        }
        this.attributeDefinitions = ImmutableMap.copyOf(checkedDefinitions);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, AttributeDefinition> getAttributeDefinitions() {
        return this.attributeDefinitions;
    }

    public void setDataConnectors(@Nullable @NullableElements Collection<DataConnector> connectors) {
        Map<String, DataConnector> checkedConnectors;
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (connectors != null) {
            checkedConnectors = new HashMap(connectors.size());
            for (DataConnector connector : connectors) {
                if (connector == null) continue;
                if (checkedConnectors.containsKey(connector.getId())) {
                    throw new IllegalArgumentException(this.logPrefix + " Duplicate Data Connector Definition with id '" + connector.getId() + "'");
                }
                checkedConnectors.put(connector.getId(), connector);
            }
        } else {
            checkedConnectors = Collections.emptyMap();
        }
        this.dataConnectors = ImmutableMap.copyOf(checkedConnectors);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, DataConnector> getDataConnectors() {
        return this.dataConnectors;
    }

    public boolean isStripNulls() {
        return this.stripNulls;
    }

    public void setStripNulls(Boolean doStripNulls) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.stripNulls = doStripNulls;
    }

    public void setPrincipalDecoder(@Nullable LegacyPrincipalDecoder principalResolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.principalConnector = principalResolver;
    }

    public void setProfileContextLookupStrategy(@Nonnull Function<AttributeResolutionContext, ProfileRequestContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.profileContextStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileRequestContext lookup strategy cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveAttributes(@Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull((Object)resolutionContext, (String)"Attribute resolution context cannot be null");
        boolean timerStarted = this.startTimer(resolutionContext);
        try {
            this.log.debug("{} Initiating attribute resolution", (Object)this.logPrefix);
            if (this.attributeDefinitions.size() == 0) {
                this.log.debug("{} No attribute definition available, no attributes were resolved", (Object)this.logPrefix);
                return;
            }
            Collection<String> attributeIds = this.getToBeResolvedAttributeIds(resolutionContext);
            this.log.debug("{} Attempting to resolve the following attribute definitions {}", (Object)this.logPrefix, attributeIds);
            AttributeResolverWorkContext workContext = (AttributeResolverWorkContext)resolutionContext.getSubcontext(AttributeResolverWorkContext.class, true);
            for (String attributeId : attributeIds) {
                this.resolveAttributeDefinition(attributeId, resolutionContext);
            }
            this.log.debug("{} Finalizing resolved attributes", (Object)this.logPrefix);
            this.finalizeResolvedAttributes(resolutionContext);
            resolutionContext.removeSubcontext((BaseContext)workContext);
            this.log.debug("{} Final resolved attribute collection: {}", (Object)this.logPrefix, resolutionContext.getResolvedIdPAttributes().keySet());
        }
        finally {
            if (timerStarted) {
                this.stopTimer(resolutionContext);
            }
        }
    }

    @Nonnull
    @NonnullElements
    protected Collection<String> getToBeResolvedAttributeIds(@Nonnull AttributeResolutionContext resolutionContext) {
        Constraint.isNotNull((Object)resolutionContext, (String)"Attribute resolution context cannot be null");
        if (resolutionContext.getRequestedIdPAttributeNames().isEmpty()) {
            LazyList attributeIds = new LazyList();
            attributeIds.addAll(this.attributeDefinitions.keySet());
            return attributeIds;
        }
        return resolutionContext.getRequestedIdPAttributeNames();
    }

    protected void resolveAttributeDefinition(@Nonnull String attributeId, @Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
        Constraint.isNotNull((Object)attributeId, (String)"Attribute ID can not be null");
        Constraint.isNotNull((Object)resolutionContext, (String)"Attribute resolution context cannot be null");
        AttributeResolverWorkContext workContext = (AttributeResolverWorkContext)resolutionContext.getSubcontext(AttributeResolverWorkContext.class, false);
        this.log.trace("{} Beginning to resolve attribute definition '{}'", (Object)this.logPrefix, (Object)attributeId);
        if (workContext.getResolvedIdPAttributeDefinitions().containsKey(attributeId)) {
            this.log.trace("{} Attribute definition '{}' was already resolved, nothing to do", (Object)this.logPrefix, (Object)attributeId);
            return;
        }
        AttributeDefinition definition = this.attributeDefinitions.get(attributeId);
        if (definition == null) {
            this.log.debug("{} No attribute definition was registered with ID '{}', nothing to do", (Object)this.logPrefix, (Object)attributeId);
            return;
        }
        this.resolveDependencies((ResolverPlugin<?>)definition, resolutionContext);
        this.log.trace("{} Resolving attribute definition {}", (Object)this.logPrefix, (Object)attributeId);
        IdPAttribute resolvedAttribute = (IdPAttribute)definition.resolve(resolutionContext);
        if (null == resolvedAttribute) {
            this.log.debug("{} Attribute definition '{}' produced no attribute", (Object)this.logPrefix, (Object)attributeId);
        } else {
            this.log.debug("{} Attribute definition '{}' produced an attribute with {} values", new Object[]{this.logPrefix, attributeId, resolvedAttribute.getValues().size()});
        }
        workContext.recordAttributeDefinitionResolution(definition, resolvedAttribute);
    }

    protected void resolveDataConnector(@Nonnull String connectorId, @Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
        Map resolvedAttributes;
        DataConnectorEx connectorEx;
        Constraint.isNotNull((Object)connectorId, (String)"Data connector ID can not be null");
        Constraint.isNotNull((Object)resolutionContext, (String)"Attribute resolution context cannot be null");
        AttributeResolverWorkContext workContext = (AttributeResolverWorkContext)resolutionContext.getSubcontext(AttributeResolverWorkContext.class, false);
        long resolveTime = System.currentTimeMillis();
        if (workContext.getResolvedDataConnectors().containsKey(connectorId)) {
            this.log.trace("{} Data connector '{}' was already resolved, nothing to do", (Object)this.logPrefix, (Object)connectorId);
            return;
        }
        DataConnector connector = this.dataConnectors.get(connectorId);
        if (connector == null) {
            this.log.debug("{} No data connector was registered with ID '{}', nothing to do", (Object)this.logPrefix, (Object)connectorId);
            return;
        }
        if (connector instanceof DataConnectorEx && resolveTime < (connectorEx = (DataConnectorEx)connector).getLastFail() + connectorEx.getNoRetryDelay()) {
            this.log.debug("{} Data connector '{}' failed to resolve previously.  Still waiting", (Object)this.logPrefix, (Object)connectorId);
            String failoverDataConnectorId = connector.getFailoverDataConnectorId();
            if (null != failoverDataConnectorId) {
                this.log.debug("{} Data connector '{}' invoking failover data connector '{}'", new Object[]{this.logPrefix, connectorId, failoverDataConnectorId});
                this.resolveDataConnector(failoverDataConnectorId, resolutionContext);
                workContext.recordFailoverResolution(connector, this.dataConnectors.get(failoverDataConnectorId));
                return;
            }
            throw new ResolutionException("Previous resolve failed");
        }
        this.resolveDependencies((ResolverPlugin<?>)connector, resolutionContext);
        try {
            this.log.debug("{} Resolving data connector {}", (Object)this.logPrefix, (Object)connectorId);
            resolvedAttributes = (Map)connector.resolve(resolutionContext);
        }
        catch (ResolutionException e) {
            String failoverDataConnectorId = connector.getFailoverDataConnectorId();
            if (null != failoverDataConnectorId) {
                this.log.debug("{} Data connector '{}' failed to resolve, invoking failover data connector '{}'.  Reason for failure:", new Object[]{this.logPrefix, connectorId, failoverDataConnectorId, e});
                this.resolveDataConnector(failoverDataConnectorId, resolutionContext);
                workContext.recordFailoverResolution(connector, this.dataConnectors.get(failoverDataConnectorId));
                return;
            }
            throw e;
        }
        if (null != resolvedAttributes) {
            this.log.debug("{} Data connector '{}' resolved the following attributes: {}", new Object[]{this.logPrefix, connectorId, resolvedAttributes.keySet()});
        } else {
            this.log.debug("{} Data connector '{}' produced no attributes", (Object)this.logPrefix, (Object)connectorId);
        }
        workContext.recordDataConnectorResolution(connector, resolvedAttributes);
    }

    protected void resolveDependencies(@Nonnull ResolverPlugin<?> plugin, @Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
        Constraint.isNotNull(plugin, (String)"Plugin dependency can not be null");
        Constraint.isNotNull((Object)resolutionContext, (String)"Attribute resolution context cannot be null");
        if (plugin.getDependencies().isEmpty()) {
            return;
        }
        this.log.debug("{} Resolving dependencies for '{}'", (Object)this.logPrefix, (Object)plugin.getId());
        for (ResolverPluginDependency dependency : plugin.getDependencies()) {
            String pluginId = dependency.getDependencyPluginId();
            if (dependency instanceof ResolverAttributeDefinitionDependency) {
                this.resolveAttributeDefinition(pluginId, resolutionContext);
                continue;
            }
            if (dependency instanceof ResolverDataConnectorDependency) {
                this.resolveDataConnector(pluginId, resolutionContext);
                continue;
            }
            if (this.attributeDefinitions.containsKey(pluginId)) {
                this.resolveAttributeDefinition(pluginId, resolutionContext);
                continue;
            }
            if (this.dataConnectors.containsKey(pluginId)) {
                this.resolveDataConnector(pluginId, resolutionContext);
                continue;
            }
            throw new ResolutionException("Plugin '" + plugin.getId() + "' contains a dependency on plugin '" + pluginId + "' which does not exist.");
        }
        this.log.debug("{} Finished resolving dependencies for '{}'", (Object)this.logPrefix, (Object)plugin.getId());
    }

    protected void finalizeResolvedAttributes(@Nonnull AttributeResolutionContext resolutionContext) {
        Constraint.isNotNull((Object)resolutionContext, (String)"Attribute resolution context cannot be null");
        AttributeResolverWorkContext workContext = (AttributeResolverWorkContext)resolutionContext.getSubcontext(AttributeResolverWorkContext.class, false);
        LazySet resolvedAttributes = new LazySet();
        for (ResolvedAttributeDefinition definition : workContext.getResolvedIdPAttributeDefinitions().values()) {
            IdPAttribute resolvedAttribute = definition.getResolvedAttribute();
            if (null == resolvedAttribute) {
                this.log.debug("{} Removing result of attribute definition '{}', it is null", (Object)this.logPrefix, (Object)definition.getId());
                continue;
            }
            if (definition.isDependencyOnly()) {
                this.log.debug("{} Removing result of attribute definition '{}', is marked as dependency only", (Object)this.logPrefix, (Object)definition.getId());
                continue;
            }
            this.log.debug("{} De-duping (and null filtering) attribute definition {} result", (Object)this.logPrefix, (Object)definition.getId());
            Iterator valueIter = resolvedAttribute.getValues().iterator();
            HashSet<IdPAttributeValue> monitor = new HashSet<IdPAttributeValue>(resolvedAttribute.getValues().size());
            while (valueIter.hasNext()) {
                IdPAttributeValue value = (IdPAttributeValue)valueIter.next();
                if (this.isStripNulls()) {
                    if (null == value) {
                        this.log.debug("{} Stripping null value", (Object)this.logPrefix);
                        continue;
                    }
                    if (value instanceof EmptyAttributeValue) {
                        this.log.debug("{} Stripping {} value", (Object)this.logPrefix, value.getValue());
                        continue;
                    }
                }
                if (monitor.add(value)) continue;
                this.log.debug("{} Removing duplicate value {} of attribute '{}' from resolution result", new Object[]{this.logPrefix, value, resolvedAttribute.getId()});
            }
            if (monitor.isEmpty()) {
                this.log.debug("{} Removing result of attribute definition '{}', contains no values", (Object)this.logPrefix, (Object)definition.getId());
                continue;
            }
            resolvedAttribute.setValues(monitor);
            this.log.debug("{} Attribute '{}' has {} values after post-processing", new Object[]{this.logPrefix, resolvedAttribute.getId(), monitor.size()});
            resolvedAttributes.add((Object)resolvedAttribute);
        }
        resolutionContext.setResolvedIdPAttributes((Collection)resolvedAttributes);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.logPrefix = "Attribute Resolver '" + this.getId() + "':";
        if (null == this.attributeDefinitions) {
            throw new ComponentInitializationException("No Attribute Definitions provided");
        }
        if (null == this.dataConnectors) {
            throw new ComponentInitializationException("No Data Connectors provided");
        }
        HashSet<String> dependencyVerifiedPlugins = new HashSet<String>();
        for (DataConnector dataConnector : this.dataConnectors.values()) {
            this.log.debug("{} Checking if data connector '{}' is has a circular dependency", (Object)this.logPrefix, (Object)dataConnector.getId());
            this.checkPlugInDependencies(dataConnector.getId(), (ResolverPlugin<?>)dataConnector, (Set<String>)dependencyVerifiedPlugins);
        }
        for (AttributeDefinition attributeDefinition : this.attributeDefinitions.values()) {
            this.log.debug("{} Checking if attribute definition '{}' has a circular dependency", (Object)this.logPrefix, (Object)attributeDefinition.getId());
            this.checkPlugInDependencies(attributeDefinition.getId(), (ResolverPlugin<?>)attributeDefinition, (Set<String>)dependencyVerifiedPlugins);
        }
    }

    protected void checkPlugInDependencies(String circularCheckPluginId, ResolverPlugin<?> plugin, Set<String> checkedPlugins) throws ComponentInitializationException {
        String pluginId = plugin.getId();
        for (ResolverPluginDependency dependency : plugin.getDependencies()) {
            String dependencyType;
            ResolverPlugin dependencyPlugin;
            if (checkedPlugins.contains(pluginId)) continue;
            if (circularCheckPluginId.equals(dependency.getDependencyPluginId())) {
                throw new ComponentInitializationException(this.logPrefix + " Plugin '" + circularCheckPluginId + "' and plugin '" + dependency.getDependencyPluginId() + "' have a circular dependency on each other.");
            }
            if (dependency instanceof ResolverAttributeDefinitionDependency) {
                dependencyPlugin = (ResolverPlugin)this.attributeDefinitions.get(dependency.getDependencyPluginId());
                dependencyType = "Attribute Definition";
            } else if (dependency instanceof ResolverDataConnectorDependency) {
                dependencyPlugin = (ResolverPlugin)this.dataConnectors.get(dependency.getDependencyPluginId());
                dependencyType = "Data Connector";
            } else {
                dependencyPlugin = (ResolverPlugin)this.attributeDefinitions.get(dependency.getDependencyPluginId());
                if (dependencyPlugin == null) {
                    dependencyPlugin = (ResolverPlugin)this.dataConnectors.get(dependency.getDependencyPluginId());
                }
                dependencyType = "Deprecated ";
            }
            if (dependencyPlugin == null) {
                throw new ComponentInitializationException(this.logPrefix + " Plugin '" + plugin.getId() + "' has a " + dependencyType + " dependency on plugin '" + dependency.getDependencyPluginId() + "' which doesn't exist");
            }
            this.checkPlugInDependencies(circularCheckPluginId, dependencyPlugin, checkedPlugins);
            checkedPlugins.add(pluginId);
        }
    }

    @Nonnull
    public AttributeResolver getComponent() {
        return this;
    }

    @Nullable
    public String canonicalize(@Nonnull SubjectCanonicalizationContext context) throws ResolutionException {
        if (null == this.principalConnector) {
            return null;
        }
        return this.principalConnector.canonicalize(context);
    }

    public boolean hasValidConnectors() {
        return this.principalConnector.hasValidConnectors();
    }

    private boolean startTimer(@Nonnull AttributeResolutionContext resolutionContext) {
        MetricContext timerCtx;
        BaseContext prc = (BaseContext)this.profileContextStrategy.apply((Object)resolutionContext);
        if (prc != null && (timerCtx = (MetricContext)prc.getSubcontext(MetricContext.class)) != null) {
            timerCtx.start(this.getId());
            return true;
        }
        return false;
    }

    private void stopTimer(@Nonnull AttributeResolutionContext resolutionContext) {
        MetricContext timerCtx;
        BaseContext prc = (BaseContext)this.profileContextStrategy.apply((Object)resolutionContext);
        if (prc != null && (timerCtx = (MetricContext)prc.getSubcontext(MetricContext.class)) != null) {
            timerCtx.stop(this.getId());
        }
    }
}

