/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.UnsupportedAttributeTypeException;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.utilities.java.support.collection.LazyMap;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeAfterInit
public class TemplateAttributeDefinition
extends AbstractAttributeDefinition {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TemplateAttributeDefinition.class);
    @NonnullAfterInit
    private Template template;
    @NonnullAfterInit
    private String templateText;
    @NonnullAfterInit
    private VelocityEngine engine;

    @NonnullAfterInit
    public Template getTemplate() {
        return this.template;
    }

    @NonnullAfterInit
    public String getTemplateText() {
        return this.templateText;
    }

    public void setTemplateText(@Nullable String velocityTemplate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.templateText = StringSupport.trimOrNull((String)velocityTemplate);
    }

    @NonnullAfterInit
    public VelocityEngine getVelocityEngine() {
        return this.engine;
    }

    public void setVelocityEngine(@Nonnull VelocityEngine velocityEngine) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.engine = (VelocityEngine)Constraint.isNotNull((Object)velocityEngine, (String)"VelocityEngine cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getAttributeDependencies().isEmpty() && this.getDataConnectorDependencies().isEmpty()) {
            throw new ComponentInitializationException(this.getLogPrefix() + " no dependencies were configured");
        }
        if (null == this.engine) {
            throw new ComponentInitializationException(this.getLogPrefix() + " no velocity engine was configured");
        }
        if (null == this.templateText) {
            throw new ComponentInitializationException(this.getLogPrefix() + " no template provided");
        }
        this.template = Template.fromTemplate((VelocityEngine)this.engine, (String)this.templateText);
    }

    @Nonnull
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        IdPAttribute resultantAttribute = new IdPAttribute(this.getId());
        LazyMap sourceValues = new LazyMap();
        int valueCount = this.setupSourceValues(workContext, (Map<String, Iterator<IdPAttributeValue>>)sourceValues);
        ArrayList<IdPAttributeValue> valueList = new ArrayList<IdPAttributeValue>(valueCount);
        for (int i = 0; i < valueCount; ++i) {
            this.log.debug("{} Determining value {}", (Object)this.getLogPrefix(), (Object)(i + 1));
            VelocityContext velocityContext = new VelocityContext();
            for (String attributeId : sourceValues.keySet()) {
                Object velocityValue;
                block11: {
                    IdPAttributeValue value;
                    block10: {
                        value = (IdPAttributeValue)((Iterator)sourceValues.get(attributeId)).next();
                        if (!(value instanceof EmptyAttributeValue)) break block10;
                        switch (((EmptyAttributeValue)value).getValue()) {
                            case NULL_VALUE: {
                                velocityValue = null;
                                break block11;
                            }
                            case ZERO_LENGTH_VALUE: {
                                velocityValue = "";
                                break block11;
                            }
                            default: {
                                throw new ResolutionException((Exception)new UnsupportedAttributeTypeException(this.getLogPrefix() + "Unknown empty attribute value type " + value.getClass()));
                            }
                        }
                    }
                    if (value instanceof StringAttributeValue) {
                        velocityValue = ((StringAttributeValue)value).getValue();
                    } else {
                        this.log.debug("{} Adding non string Attribute value : {}", (Object)this.getLogPrefix(), value.getNativeValue());
                        velocityValue = value.getNativeValue();
                    }
                }
                this.log.debug("{} Adding value '{}' for attribute '{}' to the template context", new Object[]{this.getLogPrefix(), velocityValue, attributeId});
                velocityContext.put(attributeId, velocityValue);
            }
            try {
                this.log.debug("{} Evaluating template", (Object)this.getLogPrefix());
                String templateResult = this.template.merge((Context)velocityContext);
                this.log.debug("{} Result of template evaluating was '{}'", (Object)this.getLogPrefix(), (Object)templateResult);
                valueList.add(StringAttributeValue.valueOf((String)templateResult));
                continue;
            }
            catch (VelocityException e) {
                this.log.error("{} Unable to evaluate velocity template: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
                throw new ResolutionException("Unable to evaluate template", (Exception)((Object)e));
            }
        }
        resultantAttribute.setValues(valueList);
        return resultantAttribute;
    }

    private int addAttributeValues(@Nonnull String attributeName, @Nullable List<IdPAttributeValue> attributeValues, @Nonnull @NonnullElements Map<String, Iterator<IdPAttributeValue>> sourceValues, int curValueCount) throws ResolutionException {
        int valueCount = curValueCount;
        if (null == attributeValues || 0 == attributeValues.size()) {
            this.log.debug("{} Ignoring input attribute '{}' with no values", (Object)this.getLogPrefix(), (Object)attributeName);
            return valueCount;
        }
        if (valueCount <= 0) {
            valueCount = attributeValues.size();
        } else if (attributeValues.size() != valueCount) {
            String msg = this.getLogPrefix() + " All source attributes used in TemplateAttributeDefinition must have the same number of values: '" + attributeName + "'";
            this.log.error("{} {}", (Object)this.getLogPrefix(), (Object)msg);
            throw new ResolutionException(msg);
        }
        sourceValues.put(attributeName, attributeValues.iterator());
        return valueCount;
    }

    private int setupSourceValues(@Nonnull AttributeResolverWorkContext workContext, @Nonnull @NonnullElements Map<String, Iterator<IdPAttributeValue>> sourceValues) throws ResolutionException {
        Map dependencyAttributes = PluginDependencySupport.getAllAttributeValues((AttributeResolverWorkContext)workContext, (Collection)this.getAttributeDependencies(), (Collection)this.getDataConnectorDependencies());
        int valueCount = 0;
        for (Map.Entry entry : dependencyAttributes.entrySet()) {
            valueCount = this.addAttributeValues((String)entry.getKey(), (List)entry.getValue(), sourceValues, valueCount);
        }
        return valueCount;
    }
}

