/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.DataSealer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DecryptedAttributeDefinition
extends AbstractAttributeDefinition {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DecryptedAttributeDefinition.class);
    @NonnullAfterInit
    private DataSealer sealer;

    public void setDataSealer(@Nonnull DataSealer newSealer) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sealer = (DataSealer)Constraint.isNotNull((Object)newSealer, (String)"DataSealer cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getDataConnectorDependencies().isEmpty() && this.getAttributeDependencies().isEmpty()) {
            throw new ComponentInitializationException(this.getLogPrefix() + " no dependencies were configured");
        }
        if (this.sealer == null) {
            throw new ComponentInitializationException("DataSealer cannot be null");
        }
    }

    @Nonnull
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        Constraint.isNotNull((Object)workContext, (String)"AttributeResolverWorkContext cannot be null");
        List results = PluginDependencySupport.getMergedAttributeValues((AttributeResolverWorkContext)workContext, (Collection)this.getAttributeDependencies(), (Collection)this.getDataConnectorDependencies(), (String)this.getId());
        ArrayList<Object> decryptedValues = new ArrayList<Object>(results.size());
        for (IdPAttributeValue value : results) {
            if (value instanceof EmptyAttributeValue) {
                this.log.trace("{} Passing through EmptyAttributeValue", (Object)this.getLogPrefix());
                decryptedValues.add(value);
                continue;
            }
            if (!(value instanceof StringAttributeValue)) {
                this.log.warn("{} Ignoring non-string-valued IdPAttributeValue type {}", (Object)this.getLogPrefix(), (Object)value.getClass().getSimpleName());
                continue;
            }
            this.log.trace("{} Encrypted attribute value: {}", (Object)this.getLogPrefix(), (Object)((StringAttributeValue)value).getValue());
            try {
                String decrypted = this.sealer.unwrap(((StringAttributeValue)value).getValue());
                this.log.trace("{}: Decrypted attribute value: {}", (Object)this.getLogPrefix(), (Object)decrypted);
                decryptedValues.add(new StringAttributeValue(decrypted));
            }
            catch (Exception e) {
                this.log.warn("{}: Error decrypting attribute: {}", (Object)this.getLogPrefix(), (Object)e);
            }
        }
        IdPAttribute decryptedAttribute = new IdPAttribute(this.getId());
        decryptedAttribute.setValues(decryptedValues);
        return decryptedAttribute;
    }
}

