/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.security.Principal;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.authn.principal.IdPAttributePrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class IdPAttributePrincipalValuesFunction
extends AbstractInitializableComponent
implements Function<Principal, List<IdPAttributeValue>> {
    @NonnullAfterInit
    @NotEmpty
    private String attributeName;

    public void setAttributeName(@Nonnull @NotEmpty String attrName) {
        this.attributeName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)attrName), (String)"Attribute Name cannot be null or empty");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.attributeName == null) {
            throw new ComponentInitializationException("Attribute name cannot be null or empty");
        }
    }

    @Override
    @Nullable
    public List<IdPAttributeValue> apply(@Nullable Principal principal) {
        IdPAttributePrincipal attributePrincipal;
        IdPAttribute attribute;
        if (null != principal && principal instanceof IdPAttributePrincipal && this.attributeName.equals((attribute = (attributePrincipal = (IdPAttributePrincipal)principal).getAttribute()).getId())) {
            return attribute.getValues();
        }
        return null;
    }
}

