/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.storage.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.dc.storage.StorageMappingStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.scripting.AbstractScriptEvaluator;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.opensaml.storage.StorageRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScriptedStorageMappingStrategy
extends AbstractScriptEvaluator
implements StorageMappingStrategy {
    @Nonnull
    public static final String RESULTS_STRING = "connectorResults";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedStorageMappingStrategy.class);

    private ScriptedStorageMappingStrategy(@Nonnull EvaluableScript theScript) {
        super(theScript);
    }

    @Nonnull
    public Map<String, IdPAttribute> map(@Nonnull StorageRecord<?> results) throws ResolutionException {
        this.log.debug("{} Handling StorageRecord", (Object)this.getLogPrefix());
        if (results == null) {
            this.log.debug("{} StorageRecord was missing", (Object)this.getLogPrefix());
            throw new ResolutionException(this.getLogPrefix() + " StorageRecord was missing");
        }
        try {
            return (Map)this.evaluate(new Object[]{results});
        }
        catch (RuntimeException e) {
            throw new ResolutionException(this.getLogPrefix() + " Script did not run successfully", (Exception)e);
        }
    }

    protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
        this.log.debug("{} Adding to-be-populated attribute set '{}' to script context", (Object)this.getLogPrefix(), (Object)RESULTS_STRING);
        scriptContext.setAttribute(RESULTS_STRING, new HashSet(), 100);
        scriptContext.setAttribute("record", input[0], 100);
        scriptContext.setAttribute("log", this.log, 100);
    }

    @Nullable
    protected Object finalizeContext(@Nonnull ScriptContext scriptContext, @Nullable Object scriptResult) throws ScriptException {
        Object res = scriptContext.getAttribute(RESULTS_STRING);
        if (null == res) {
            this.log.error("{} Could not locate output variable '{}' from script", (Object)this.getLogPrefix(), (Object)RESULTS_STRING);
            throw new ScriptException("Could not locate output from script");
        }
        if (!(res instanceof Collection)) {
            this.log.error("{} Output '{}' was of type '{}', expected '{}'", new Object[]{this.getLogPrefix(), res.getClass().getName(), Collection.class.getName()});
            throw new ScriptException("Output was of the wrong type");
        }
        Collection outputCollection = (Collection)res;
        HashMap<String, IdPAttribute> outputMap = new HashMap<String, IdPAttribute>(outputCollection.size());
        for (Object o : outputCollection) {
            if (o instanceof IdPAttribute) {
                IdPAttribute attribute = (IdPAttribute)o;
                if (null == attribute.getId()) {
                    this.log.warn("{} Anonymous Attribute encountered, ignored", (Object)this.getLogPrefix());
                    continue;
                }
                this.checkValues(attribute);
                outputMap.put(attribute.getId(), attribute);
                continue;
            }
            this.log.warn("{} Output collection contained an object of type '{}', ignored", (Object)this.getLogPrefix(), (Object)o.getClass().getName());
        }
        return outputMap;
    }

    private void checkValues(IdPAttribute attribute) {
        if (null == attribute.getValues()) {
            this.log.info("{} Attribute '{}' has no values provided.", (Object)this.getLogPrefix(), (Object)attribute.getId());
            attribute.setValues(Collections.emptyList());
            return;
        }
        this.log.debug("{} Attribute '{}' has {} value(s).", new Object[]{this.getLogPrefix(), attribute.getId(), attribute.getValues().size()});
        List inputValues = attribute.getValues();
        ArrayList<IdPAttributeValue> outputValues = new ArrayList<IdPAttributeValue>(inputValues.size());
        for (Object o : inputValues) {
            if (o instanceof IdPAttributeValue) {
                outputValues.add((IdPAttributeValue)o);
                continue;
            }
            this.log.error("{} Attribute '{} has attribute value of type {}.  This will be ignored", new Object[]{this.getLogPrefix(), attribute.getId(), o.getClass().getName()});
        }
        attribute.setValues(outputValues);
    }

    @Nonnull
    static ScriptedStorageMappingStrategy resourceScript(@Nonnull @NotEmpty String engineName, @Nonnull Resource resource) throws ScriptException, IOException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript();
            script.setEngineName(engineName);
            script.setScript(is);
            script.initializeWithScriptException();
            ScriptedStorageMappingStrategy scriptedStorageMappingStrategy = new ScriptedStorageMappingStrategy(script);
            return scriptedStorageMappingStrategy;
        }
    }

    @Nonnull
    static ScriptedStorageMappingStrategy resourceScript(@Nonnull Resource resource) throws ScriptException, IOException {
        return ScriptedStorageMappingStrategy.resourceScript("JavaScript", resource);
    }

    @Nonnull
    static ScriptedStorageMappingStrategy inlineScript(@Nonnull @NotEmpty String engineName, @Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(scriptSource);
        script.initializeWithScriptException();
        return new ScriptedStorageMappingStrategy(script);
    }

    @Nonnull
    static ScriptedStorageMappingStrategy inlineScript(@Nonnull @NotEmpty String scriptSource) throws ScriptException {
        return ScriptedStorageMappingStrategy.inlineScript("JavaScript", scriptSource);
    }
}

