/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.storage.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.ExecutableSearchBuilder;
import net.shibboleth.idp.attribute.resolver.dc.storage.StorageServiceSearch;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplatedSearchBuilder
extends AbstractInitializableComponent
implements ExecutableSearchBuilder<StorageServiceSearch> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TemplatedSearchBuilder.class);
    @NonnullAfterInit
    private Template contextTemplate;
    @NonnullAfterInit
    private Template keyTemplate;
    @NonnullAfterInit
    private String contextTemplateText;
    @NonnullAfterInit
    private String keyTemplateText;
    @NonnullAfterInit
    private VelocityEngine engine;
    @Nullable
    private Object customObject;

    @NonnullAfterInit
    public Template getContextTemplate() {
        return this.contextTemplate;
    }

    @NonnullAfterInit
    public Template getKeyTemplate() {
        return this.keyTemplate;
    }

    @NonnullAfterInit
    public String getContextTemplateText() {
        return this.contextTemplateText;
    }

    public void setContextTemplateText(@Nullable String text) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.contextTemplateText = StringSupport.trimOrNull((String)text);
    }

    @NonnullAfterInit
    public String getKeyTemplateText() {
        return this.keyTemplateText;
    }

    public void setKeyTemplateText(@Nullable String text) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.keyTemplateText = StringSupport.trimOrNull((String)text);
    }

    @NonnullAfterInit
    public VelocityEngine getVelocityEngine() {
        return this.engine;
    }

    public void setVelocityEngine(@Nonnull VelocityEngine velocityEngine) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.engine = (VelocityEngine)Constraint.isNotNull((Object)velocityEngine, (String)"Velocity engine cannot be null");
    }

    public void setCustomObject(@Nullable Object object) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.customObject = object;
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (null == this.engine) {
            throw new ComponentInitializationException("Velocity engine cannot be null");
        }
        if (null == this.contextTemplateText) {
            throw new ComponentInitializationException("Context template text cannot be null");
        }
        if (null == this.keyTemplateText) {
            throw new ComponentInitializationException("Key template text cannot be null");
        }
        this.contextTemplate = Template.fromTemplate((VelocityEngine)this.engine, (String)this.contextTemplateText);
        this.keyTemplate = Template.fromTemplate((VelocityEngine)this.engine, (String)this.keyTemplateText);
    }

    public StorageServiceSearch build(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) throws ResolutionException {
        final Pair<String, String> searchParams = this.getContextAndKey(resolutionContext, dependencyAttributes);
        return new StorageServiceSearch(){

            @Nullable
            public String getResultCacheKey() {
                if (searchParams.getFirst() != null && searchParams.getSecond() != null) {
                    return (String)searchParams.getFirst() + "!" + (String)searchParams.getSecond();
                }
                return null;
            }

            public StorageRecord<?> execute(@Nonnull StorageService storageService) throws IOException {
                return storageService.read((String)searchParams.getFirst(), (String)searchParams.getSecond());
            }
        };
    }

    @Nonnull
    private Pair<String, String> getContextAndKey(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) throws ResolutionException {
        VelocityContext context = new VelocityContext();
        this.log.trace("Creating search criteria using attribute resolution context {}", (Object)resolutionContext);
        context.put("resolutionContext", (Object)resolutionContext);
        context.put("custom", this.customObject);
        if (dependencyAttributes != null && !dependencyAttributes.isEmpty()) {
            for (Map.Entry<String, List<IdPAttributeValue>> entry : dependencyAttributes.entrySet()) {
                ArrayList<Object> values = new ArrayList<Object>(entry.getValue().size());
                for (IdPAttributeValue value : entry.getValue()) {
                    values.add(value.getNativeValue());
                }
                this.log.trace("Adding dependency {} to context with {} value(s)", (Object)entry.getKey(), (Object)values.size());
                context.put(entry.getKey(), values);
            }
        }
        try {
            String ctx = this.contextTemplate.merge((Context)context);
            String key = this.keyTemplate.merge((Context)context);
            this.log.debug("Produced search context '{}', key '{}'", (Object)ctx, (Object)key);
            return new Pair((Object)ctx, (Object)key);
        }
        catch (VelocityException e) {
            this.log.error("Error running template engine: {}", (Object)e.getMessage());
            throw new ResolutionException("Error running template engine", (Exception)((Object)e));
        }
    }
}

