/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.context.navigate.SubjectCanonicalizationContextSubjectLookupFunction;
import net.shibboleth.idp.authn.principal.IdPAttributePrincipal;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SubjectDataConnector
extends AbstractDataConnector {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SubjectDataConnector.class);
    private boolean forCanonicalization;
    @Nonnull
    private Function<ProfileRequestContext, SubjectContext> scLookupStrategy = new ChildContextLookup(SubjectContext.class);
    @Nullable
    private Function<ProfileRequestContext, Subject> subjectLookupStrategy;
    private boolean noResultIsError;

    public boolean isForCanonicalization() {
        return this.forCanonicalization;
    }

    public void setForCanonicalization(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.forCanonicalization = flag;
    }

    public void setSubjectContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SubjectContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.scLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectContext lookup strategy cannot be null");
    }

    public void setSubjectLookupStrategy(@Nullable Function<ProfileRequestContext, Subject> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.subjectLookupStrategy = strategy;
    }

    public boolean isNoResultIsError() {
        return this.noResultIsError;
    }

    public void setNoResultIsError(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.noResultIsError = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.forCanonicalization && this.subjectLookupStrategy == null) {
            this.log.debug("{} Marked for use during canonicalication, auto-installing Subject lookup strategy", (Object)this.getLogPrefix());
            this.subjectLookupStrategy = new SubjectCanonicalizationContextSubjectLookupFunction().compose((Function)new ChildContextLookup(SubjectCanonicalizationContext.class));
        }
    }

    @Nonnull
    protected Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        List subjects = Collections.emptyList();
        if (this.subjectLookupStrategy != null) {
            Subject subject = this.subjectLookupStrategy.apply((ProfileRequestContext)this.getProfileContextStrategy().apply(resolutionContext));
            if (subject == null) {
                this.log.debug("{} No Subject returned from lookup, no attributes resolved", (Object)this.getLogPrefix());
                return Collections.emptyMap();
            }
            subjects = Collections.singletonList(subject);
        } else {
            SubjectContext cs = this.scLookupStrategy.apply((ProfileRequestContext)this.getProfileContextStrategy().apply(resolutionContext));
            if (cs == null || cs.getSubjects().isEmpty()) {
                this.log.debug("{} No Subjects returned from SubjectContext lookup, no attributes resolved", (Object)this.getLogPrefix());
                return Collections.emptyMap();
            }
            subjects = cs.getSubjects();
        }
        HashMap<String, IdPAttribute> results = new HashMap<String, IdPAttribute>();
        for (Subject subject : subjects) {
            for (IdPAttributePrincipal principal : subject.getPrincipals(IdPAttributePrincipal.class)) {
                results.put(principal.getName(), principal.getAttribute());
            }
        }
        if (results.isEmpty()) {
            if (this.noResultIsError) {
                throw new ResolutionException("No IdPAttributePrincipal objects found");
            }
            this.log.debug("{} Obtained no attributes from Subjects for principal '{}'", (Object)this.getLogPrefix(), (Object)resolutionContext.getPrincipal());
            return Collections.emptyMap();
        }
        this.log.debug("{} Extracted {} IdPAttribute(s)", (Object)this.getLogPrefix(), (Object)results.size());
        this.log.trace("{} Extracted atttribute IDs: {}", (Object)this.getLogPrefix(), results.keySet());
        return results;
    }
}

