/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.scripted.ScriptedIdPAttribute;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptedIdPAttributeImpl
implements ScriptedIdPAttribute {
    private final IdPAttribute encapsulatedAttribute;
    private final Logger log = LoggerFactory.getLogger(ScriptedIdPAttributeImpl.class);
    private boolean calledGetNativeAttribute;
    private List<Object> attributeValues;
    private final String logPrefix;

    public ScriptedIdPAttributeImpl(@Nonnull IdPAttribute attribute, String prefix) {
        this.encapsulatedAttribute = attribute;
        this.logPrefix = prefix + " scripted attribute '" + attribute.getId() + "':";
    }

    private void setupAttributeValues() {
        if (null != this.attributeValues) {
            return;
        }
        this.log.debug("{} values being prepared", (Object)this.getLogPrefix());
        ArrayList<Object> newValues = new ArrayList<Object>(this.encapsulatedAttribute.getValues().size());
        for (IdPAttributeValue value : this.encapsulatedAttribute.getValues()) {
            if (value instanceof StringAttributeValue && !(value instanceof ScopedStringAttributeValue)) {
                newValues.add(((StringAttributeValue)value).getValue());
                continue;
            }
            if (value instanceof EmptyAttributeValue) {
                newValues.add(null);
                continue;
            }
            newValues.add(value);
        }
        this.attributeValues = newValues;
        this.log.debug("{} values are : {}", (Object)this.getLogPrefix(), newValues);
    }

    @Nullable
    @NonnullElements
    public Collection<Object> getValues() throws ResolutionException {
        if (this.calledGetNativeAttribute) {
            throw new ResolutionException(this.getLogPrefix() + " cannot call getNativeAttribute() and getValues() or addValues() on the same attribute()");
        }
        if (null == this.attributeValues) {
            this.setupAttributeValues();
        }
        return this.attributeValues;
    }

    @Nonnull
    public IdPAttribute getNativeAttribute() throws ResolutionException {
        if (null != this.attributeValues) {
            throw new ResolutionException(this.getLogPrefix() + "': cannot call getNativeAttribute() and getValues()/setValues() on the same attribute()");
        }
        this.calledGetNativeAttribute = true;
        return this.encapsulatedAttribute;
    }

    @Nonnull
    @NotEmpty
    public String getId() {
        return this.encapsulatedAttribute.getId();
    }

    private void addAsIdPAttributeValue(List<IdPAttributeValue> values, Object value) {
        if (null == value) {
            values.add((IdPAttributeValue)new EmptyAttributeValue(EmptyAttributeValue.EmptyType.NULL_VALUE));
        } else if (value instanceof String) {
            values.add(StringAttributeValue.valueOf((String)((String)value)));
        } else {
            values.add((IdPAttributeValue)value);
        }
    }

    private void policeValueType(@Nullable Object what) throws ResolutionException {
        if (null != what && !(what instanceof String) && !(what instanceof IdPAttributeValue)) {
            throw new ResolutionException(this.getLogPrefix() + " added element must be a String or AttributeValue, provided = " + what.getClass().toString());
        }
    }

    public void addValue(@Nullable Object what) throws ResolutionException {
        this.policeValueType(what);
        if (null == this.attributeValues) {
            this.setupAttributeValues();
        }
        this.attributeValues.add(what);
    }

    @Nonnull
    protected IdPAttribute getResultingAttribute() throws ResolutionException {
        if (null == this.attributeValues) {
            this.log.debug("{} return initial attribute unchanged", (Object)this.getLogPrefix());
            return this.encapsulatedAttribute;
        }
        ArrayList<IdPAttributeValue> valueList = new ArrayList<IdPAttributeValue>(this.attributeValues.size());
        this.log.debug("{} recreating attribute contents from {}", (Object)this.getLogPrefix(), this.attributeValues);
        for (Object object : this.attributeValues) {
            this.policeValueType(object);
            this.addAsIdPAttributeValue(valueList, object);
        }
        this.encapsulatedAttribute.setValues(valueList);
        this.log.debug("{} recreated attribute contents are {}", (Object)this.getLogPrefix(), valueList);
        return this.encapsulatedAttribute;
    }

    @Nonnull
    protected String getLogPrefix() {
        return this.logPrefix;
    }
}

