/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.ldap.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.resolver.dc.ValidationException;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactoryValidator
extends AbstractInitializableComponent
implements Validator {
    private final Logger log = LoggerFactory.getLogger(ConnectionFactoryValidator.class);
    @Nonnull
    private ConnectionFactory connectionFactory;
    private boolean throwOnValidateError;

    protected void doInitialize() throws ComponentInitializationException {
        Constraint.isNotNull((Object)this.connectionFactory, (String)"Connection factory must be non-null");
        super.doInitialize();
    }

    @Nonnull
    public void setConnectionFactory(@Nonnull ConnectionFactory factory) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.connectionFactory = (ConnectionFactory)Constraint.isNotNull((Object)factory, (String)"Connection factory must be non-null");
    }

    @Nonnull
    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setThrowValidateError(boolean what) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.throwOnValidateError = what;
    }

    public boolean isThrowValidateError() {
        return this.throwOnValidateError;
    }

    public void validate() throws ValidationException {
        try (Connection connection = null;){
            connection = this.connectionFactory.getConnection();
            if (connection == null) {
                this.log.error("Unable to retrieve connections from configured connection factory");
                if (this.isThrowValidateError()) {
                    throw new LdapException("Unable to retrieve connection from connection factory");
                }
            }
            connection.open();
        }
    }
}

