/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.storage.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.NoResultAnErrorResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.dc.ValidationException;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.idp.attribute.resolver.dc.impl.AbstractSearchDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.storage.StorageMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.storage.StorageServiceSearch;
import net.shibboleth.idp.attribute.resolver.dc.storage.impl.SimpleStorageMappingStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageServiceDataConnector
extends AbstractSearchDataConnector<StorageServiceSearch, StorageMappingStrategy> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StorageServiceDataConnector.class);
    @NonnullAfterInit
    private StorageService storageService;
    @NonnullAfterInit
    private String generatedAttributeID;
    private boolean noResultAnError;

    public StorageServiceDataConnector() {
        this.setValidator(new Validator(){

            public void validate() throws ValidationException {
            }

            public void setThrowValidateError(boolean what) {
            }

            public boolean isThrowValidateError() {
                return false;
            }
        });
    }

    public void setStorageService(@Nonnull StorageService service) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.storageService = (StorageService)Constraint.isNotNull((Object)service, (String)"StorageService cannot be null");
    }

    @NonnullAfterInit
    public String getGeneratedAttributeID() {
        return this.generatedAttributeID;
    }

    public void setNoResultAnError(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.noResultAnError = flag;
    }

    public void setGeneratedAttributeID(@Nullable String id) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.generatedAttributeID = StringSupport.trimOrNull((String)id);
    }

    @Override
    public void doInitialize() throws ComponentInitializationException {
        if (this.storageService == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " StorageService cannot be null");
        }
        if (this.getMappingStrategy() == null) {
            if (this.generatedAttributeID == null) {
                throw new ComponentInitializationException(this.getLogPrefix() + " No mapping strategy or generated attribute ID set");
            }
            this.setMappingStrategy(new SimpleStorageMappingStrategy(this.generatedAttributeID));
        }
        super.doInitialize();
    }

    @Override
    @Nullable
    protected Map<String, IdPAttribute> retrieveAttributes(@Nonnull StorageServiceSearch executable) throws ResolutionException {
        try {
            StorageRecord record = executable.execute(this.storageService);
            if (record == null) {
                if (this.noResultAnError) {
                    throw new NoResultAnErrorResolutionException(this.getLogPrefix() + " No record returned");
                }
                return Collections.emptyMap();
            }
            return ((StorageMappingStrategy)this.getMappingStrategy()).map((Object)record);
        }
        catch (IOException e) {
            throw new ResolutionException(this.getLogPrefix() + " StorageService read failed", (Exception)e);
        }
    }
}

