/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.impl;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.collection.CollectionSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class StaticDataConnector
extends AbstractDataConnector {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StaticDataConnector.class);
    @NonnullAfterInit
    @NonnullElements
    private Map<String, IdPAttribute> attributes;

    @Nullable
    @NonnullAfterInit
    public Map<String, IdPAttribute> getAttributes() {
        return this.attributes;
    }

    public void setValues(@Nonnull @NonnullElements Collection<IdPAttribute> newValues) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull(newValues, (String)"Values must not be null");
        this.attributes = newValues.stream().map(e -> (IdPAttribute)Constraint.isNotNull((Object)e, (String)"non null Attribute in connector")).collect(Collectors.toUnmodifiableMap(IdPAttribute::getId, i -> i, CollectionSupport.warningMergeFunction((String)("StaticDataConnector " + this.getId()), (boolean)true)));
    }

    @Nonnull
    protected Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.log.trace("{} Resolved attributes: {}", (Object)this.getLogPrefix(), this.attributes);
        return this.attributes;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.attributes) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No values set up.");
        }
    }
}

