/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.http.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.dc.http.HTTPResponseMappingStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.scripting.AbstractScriptEvaluator;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScriptedResponseMappingStrategy
extends AbstractScriptEvaluator
implements HTTPResponseMappingStrategy {
    @Nonnull
    public static final String RESULTS_STRING = "connectorResults";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedResponseMappingStrategy.class);
    @Nonnull
    private Set<Integer> acceptStatuses = Collections.singleton(200);
    @Nonnull
    private Set<String> acceptTypes = Collections.emptySet();
    private long maxLength;

    private ScriptedResponseMappingStrategy(@Nonnull EvaluableScript theScript) {
        super(theScript);
    }

    public void setAcceptStatuses(@Nonnull @NonnullElements Collection<Integer> statuses) {
        this.acceptStatuses = Set.copyOf((Collection)Constraint.isNotNull(statuses, (String)"Statuses cannot be null"));
    }

    public void setAcceptTypes(@Nonnull @NonnullElements Collection<String> types) {
        this.acceptTypes = Set.copyOf(StringSupport.normalizeStringCollection((Collection)((Collection)Constraint.isNotNull(types, (String)"Types cannot be null"))));
    }

    public void setMaxLength(long len) {
        this.maxLength = len;
    }

    @Nonnull
    public Map<String, IdPAttribute> map(@Nonnull Map<String, IdPAttribute> results) throws ResolutionException {
        return results;
    }

    public Map<String, IdPAttribute> handleResponse(HttpResponse response) throws IOException {
        this.log.debug("{} Handling HTTP response", (Object)this.getLogPrefix());
        if (response == null) {
            this.log.debug("{} HTTP response was missing", (Object)this.getLogPrefix());
            throw new IOException(this.getLogPrefix() + " HTTP response was missing");
        }
        this.checkStatus(response);
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            this.log.debug("{} Response body was missing", (Object)this.getLogPrefix());
            throw new IOException(this.getLogPrefix() + " Response body was missing");
        }
        this.checkContentType(entity);
        this.checkContentLength(entity);
        try {
            return (Map)this.evaluate(new Object[]{response});
        }
        catch (RuntimeException e) {
            throw new IOException(this.getLogPrefix() + " Script did not run successfully", e);
        }
    }

    protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
        this.log.debug("{} Adding to-be-populated attribute set '{}' to script context", (Object)this.getLogPrefix(), (Object)RESULTS_STRING);
        scriptContext.setAttribute(RESULTS_STRING, new HashSet(), 100);
        scriptContext.setAttribute("response", input[0], 100);
        scriptContext.setAttribute("log", this.log, 100);
    }

    @Nullable
    protected Object finalizeContext(@Nonnull ScriptContext scriptContext, @Nullable Object scriptResult) throws ScriptException {
        Object res = scriptContext.getAttribute(RESULTS_STRING);
        if (null == res) {
            this.log.error("{} Could not locate output variable '{}' from script", (Object)this.getLogPrefix(), (Object)RESULTS_STRING);
            throw new ScriptException("Could not locate output from script");
        }
        if (!(res instanceof Collection)) {
            this.log.error("{} Output '{}' was of type '{}', expected '{}'", new Object[]{this.getLogPrefix(), res.getClass().getName(), Collection.class.getName()});
            throw new ScriptException("Output was of the wrong type");
        }
        Collection outputCollection = (Collection)res;
        HashMap<String, IdPAttribute> outputMap = new HashMap<String, IdPAttribute>(outputCollection.size());
        for (Object o : outputCollection) {
            if (o instanceof IdPAttribute) {
                IdPAttribute attribute = (IdPAttribute)o;
                if (null == attribute.getId()) {
                    this.log.warn("{} Anonymous Attribute encountered, ignored", (Object)this.getLogPrefix());
                    continue;
                }
                this.checkValues(attribute);
                outputMap.put(attribute.getId(), attribute);
                continue;
            }
            this.log.warn("{} Output collection contained an object of type '{}', ignored", (Object)this.getLogPrefix(), (Object)o.getClass().getName());
        }
        return outputMap;
    }

    private void checkStatus(@Nonnull HttpResponse response) throws IOException {
        if (!(this.acceptStatuses.isEmpty() || response.getStatusLine() != null && this.acceptStatuses.contains(response.getStatusLine().getStatusCode()))) {
            this.log.debug("{} Unacceptable HTTP status: {}", (Object)this.getLogPrefix(), response.getStatusLine() != null ? Integer.valueOf(response.getStatusLine().getStatusCode()) : "unknown");
            throw new IOException(this.getLogPrefix() + " HTTP status unknown or unacceptable");
        }
    }

    private void checkContentType(@Nonnull HttpEntity entity) throws IOException {
        ContentType contentType;
        if (!(this.acceptTypes.isEmpty() || (contentType = ContentType.get((HttpEntity)entity)) != null && this.acceptTypes.contains(contentType.getMimeType()))) {
            this.log.debug("{} Unacceptable Content-Type: {}", (Object)this.getLogPrefix(), (Object)(contentType != null ? contentType.getMimeType() : "unknown"));
            throw new IOException(this.getLogPrefix() + " Content-Type unknown or unacceptable");
        }
    }

    private void checkContentLength(@Nonnull HttpEntity entity) throws IOException {
        if (this.maxLength > 0L && (entity.getContentLength() < 0L || entity.getContentLength() > this.maxLength)) {
            this.log.debug("{} Unacceptable Content-Length: {}", (Object)this.getLogPrefix(), (Object)entity.getContentLength());
            throw new IOException(this.getLogPrefix() + " Content-Length exceeded acceptable limits or was unset");
        }
    }

    private void checkValues(IdPAttribute attribute) {
        if (null == attribute.getValues()) {
            this.log.info("{} Attribute '{}' has no values provided.", (Object)this.getLogPrefix(), (Object)attribute.getId());
            attribute.setValues(Collections.emptyList());
            return;
        }
        this.log.debug("{} Attribute '{}' has {} value(s).", new Object[]{this.getLogPrefix(), attribute.getId(), attribute.getValues().size()});
        List inputValues = attribute.getValues();
        ArrayList<IdPAttributeValue> outputValues = new ArrayList<IdPAttributeValue>(inputValues.size());
        for (Object o : inputValues) {
            if (o instanceof IdPAttributeValue) {
                outputValues.add((IdPAttributeValue)o);
                continue;
            }
            this.log.error("{} Attribute '{} has attribute value of type {}.  This will be ignored", new Object[]{this.getLogPrefix(), attribute.getId(), o.getClass().getName()});
        }
        attribute.setValues(outputValues);
    }

    @Nonnull
    static ScriptedResponseMappingStrategy resourceScript(@Nonnull @NotEmpty String engineName, @Nonnull Resource resource) throws ScriptException, IOException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript();
            script.setEngineName(engineName);
            script.setScript(is);
            script.initializeWithScriptException();
            ScriptedResponseMappingStrategy scriptedResponseMappingStrategy = new ScriptedResponseMappingStrategy(script);
            return scriptedResponseMappingStrategy;
        }
    }

    @Nonnull
    static ScriptedResponseMappingStrategy resourceScript(@Nonnull Resource resource) throws ScriptException, IOException {
        return ScriptedResponseMappingStrategy.resourceScript("JavaScript", resource);
    }

    @Nonnull
    static ScriptedResponseMappingStrategy inlineScript(@Nonnull @NotEmpty String engineName, @Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(scriptSource);
        script.initializeWithScriptException();
        return new ScriptedResponseMappingStrategy(script);
    }

    @Nonnull
    static ScriptedResponseMappingStrategy inlineScript(@Nonnull @NotEmpty String scriptSource) throws ScriptException {
        return ScriptedResponseMappingStrategy.inlineScript("JavaScript", scriptSource);
    }
}

