/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.storage.impl;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.dc.storage.StorageMappingStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.storage.StorageRecord;

public class SimpleStorageMappingStrategy
implements StorageMappingStrategy {
    @Nonnull
    @NotEmpty
    private final String attributeId;

    public SimpleStorageMappingStrategy(@Nonnull @NotEmpty String id) {
        this.attributeId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"Attribute ID cannot be null or empty");
    }

    @Nonnull
    @NonnullElements
    public Map<String, IdPAttribute> map(@Nonnull StorageRecord<?> results) throws ResolutionException {
        IdPAttribute attribute = new IdPAttribute(this.attributeId);
        attribute.setValues(Collections.singletonList(StringAttributeValue.valueOf((String)results.getValue())));
        return Collections.singletonMap(this.attributeId, attribute);
    }
}

