/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.ext.spring.service.AbstractServiceableComponent;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.resolver.AbstractResolverPlugin;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.NoResultAnErrorResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolvedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ResolvedDataConnector;
import net.shibboleth.idp.attribute.resolver.ResolverAttributeDefinitionDependency;
import net.shibboleth.idp.attribute.resolver.ResolverDataConnectorDependency;
import net.shibboleth.idp.attribute.resolver.ResolverPlugin;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.collection.LazyList;
import net.shibboleth.utilities.java.support.collection.LazyMap;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.profile.context.MetricContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AttributeResolverImpl
extends AbstractServiceableComponent<AttributeResolver>
implements AttributeResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeResolverImpl.class);
    @NonnullAfterInit
    private Map<String, AttributeDefinition> attributeDefinitions;
    @NonnullAfterInit
    private Map<String, DataConnector> dataConnectors;
    @NonnullAfterInit
    private String logPrefix;
    @NonnullAfterInit
    private List<String> preRequestedAttributes;
    private boolean stripNulls;
    private boolean suppressDisplayInformation;
    @Nonnull
    private Function<AttributeResolutionContext, ProfileRequestContext> profileContextStrategy = new ParentContextLookup(ProfileRequestContext.class);

    public void setAttributeDefinitions(@Nonnull @NonnullElements Collection<AttributeDefinition> definitions) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(definitions, (String)"Attribute Defintions should be non-null");
        HashMap<String, AttributeDefinition> checkedDefinitions = new HashMap<String, AttributeDefinition>(definitions.size());
        for (AttributeDefinition definition : definitions) {
            if (definition == null) continue;
            if (checkedDefinitions.containsKey(definition.getId())) {
                throw new IllegalArgumentException(this.logPrefix + " Duplicate Attribute Definition with id '" + definition.getId() + "'");
            }
            checkedDefinitions.put(definition.getId(), definition);
        }
        this.attributeDefinitions = Map.copyOf(checkedDefinitions);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, AttributeDefinition> getAttributeDefinitions() {
        return this.attributeDefinitions;
    }

    public void setDataConnectors(@Nonnull @NonnullElements Collection<DataConnector> connectors) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(connectors, (String)"Data Connectors should be non-null");
        HashMap<String, DataConnector> checkedConnectors = new HashMap<String, DataConnector>(connectors.size());
        for (DataConnector connector : connectors) {
            if (connector == null) continue;
            if (checkedConnectors.containsKey(connector.getId())) {
                throw new IllegalArgumentException(this.logPrefix + " Duplicate Data Connector Definition with id '" + connector.getId() + "'");
            }
            checkedConnectors.put(connector.getId(), connector);
        }
        this.dataConnectors = Map.copyOf(checkedConnectors);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, DataConnector> getDataConnectors() {
        return this.dataConnectors;
    }

    public boolean isStripNulls() {
        return this.stripNulls;
    }

    public void setStripNulls(Boolean doStripNulls) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.stripNulls = doStripNulls;
    }

    public boolean isSuppressDisplayInformation() {
        return this.suppressDisplayInformation;
    }

    @Deprecated(forRemoval=true, since="4.2")
    public void setSuppressDisplayInformation(boolean what) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.suppressDisplayInformation = what;
    }

    public void setProfileContextLookupStrategy(@Nonnull Function<AttributeResolutionContext, ProfileRequestContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"setProfileContextLookupStrategy", (String)"AttributeResolverImpl", (String)"(will be removed)");
        this.profileContextStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileRequestContext lookup strategy cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveAttributes(@Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
        boolean timerStarted;
        AttributeContext attributeContext;
        AttributeResolverWorkContext workContext;
        block13: {
            ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
            ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
            Constraint.isNotNull((Object)resolutionContext, (String)"Attribute resolution context cannot be null");
            workContext = (AttributeResolverWorkContext)resolutionContext.getSubcontext(AttributeResolverWorkContext.class, true);
            attributeContext = null;
            timerStarted = this.startTimer(resolutionContext);
            this.log.debug("{} Initiating attribute resolution with label: {}", (Object)this.logPrefix, (Object)resolutionContext.getResolutionLabel());
            if (!this.preRequestedAttributes.isEmpty()) {
                this.log.debug("Resolving pre-requested Attributes");
                for (String string : this.preRequestedAttributes) {
                    this.resolveAttributeDefinition(string, resolutionContext);
                }
                this.finalizePreResolvedAttributes(resolutionContext);
            }
            attributeContext = (AttributeContext)resolutionContext.getSubcontext(AttributeContext.class, true);
            boolean hasExportingDataConnector = false;
            for (Map.Entry<String, DataConnector> entry : this.dataConnectors.entrySet()) {
                if (!entry.getValue().isExportAllAttributes() && entry.getValue().getExportAttributes().isEmpty()) continue;
                hasExportingDataConnector = true;
                this.resolveDataConnector(entry.getKey(), resolutionContext);
            }
            if (this.attributeDefinitions.size() != 0 || hasExportingDataConnector) break block13;
            this.log.debug("{} No attribute definition available or exporting data connectors, no attributes were resolved", (Object)this.logPrefix);
            resolutionContext.removeSubcontext((BaseContext)workContext);
            if (attributeContext != null) {
                resolutionContext.removeSubcontext((BaseContext)attributeContext);
            }
            if (timerStarted) {
                this.stopTimer(resolutionContext);
            }
            return;
        }
        try {
            Collection<String> collection = this.getToBeResolvedAttributeIds(resolutionContext);
            this.log.debug("{} Attempting to resolve the following attribute definitions {}", (Object)this.logPrefix, collection);
            for (String attributeId : collection) {
                this.resolveAttributeDefinition(attributeId, resolutionContext);
            }
            this.log.debug("{} Finalizing resolved attributes", (Object)this.logPrefix);
            this.finalizeResolvedAttributes(resolutionContext);
            this.log.debug("{} Final resolved attribute collection: {}", (Object)this.logPrefix, resolutionContext.getResolvedIdPAttributes().keySet());
        }
        catch (Throwable throwable) {
            resolutionContext.removeSubcontext((BaseContext)workContext);
            if (attributeContext != null) {
                resolutionContext.removeSubcontext(attributeContext);
            }
            if (timerStarted) {
                this.stopTimer(resolutionContext);
            }
            throw throwable;
        }
        resolutionContext.removeSubcontext((BaseContext)workContext);
        if (attributeContext != null) {
            resolutionContext.removeSubcontext((BaseContext)attributeContext);
        }
        if (timerStarted) {
            this.stopTimer(resolutionContext);
        }
    }

    @Nonnull
    @NonnullElements
    protected Collection<String> getToBeResolvedAttributeIds(@Nonnull AttributeResolutionContext resolutionContext) {
        Constraint.isNotNull((Object)resolutionContext, (String)"Attribute resolution context cannot be null");
        if (resolutionContext.getRequestedIdPAttributeNames().isEmpty()) {
            LazyList attributeIds = new LazyList();
            attributeIds.addAll(this.attributeDefinitions.keySet());
            return attributeIds;
        }
        return resolutionContext.getRequestedIdPAttributeNames();
    }

    protected void resolveAttributeDefinition(@Nonnull String attributeId, @Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
        Constraint.isNotNull((Object)attributeId, (String)"Attribute ID can not be null");
        Constraint.isNotNull((Object)resolutionContext, (String)"Attribute resolution context cannot be null");
        AttributeResolverWorkContext workContext = (AttributeResolverWorkContext)resolutionContext.getSubcontext(AttributeResolverWorkContext.class, false);
        this.log.trace("{} Beginning to resolve attribute definition '{}'", (Object)this.logPrefix, (Object)attributeId);
        if (workContext.getResolvedIdPAttributeDefinitions().containsKey(attributeId)) {
            this.log.trace("{} Attribute definition '{}' was already resolved, nothing to do", (Object)this.logPrefix, (Object)attributeId);
            return;
        }
        AttributeDefinition definition = this.attributeDefinitions.get(attributeId);
        if (definition == null) {
            this.log.debug("{} No attribute definition was registered with ID '{}', nothing to do", (Object)this.logPrefix, (Object)attributeId);
            return;
        }
        this.resolveDependencies((ResolverPlugin<?>)definition, resolutionContext);
        this.log.trace("{} Resolving attribute definition {}", (Object)this.logPrefix, (Object)attributeId);
        IdPAttribute resolvedAttribute = (IdPAttribute)definition.resolve(resolutionContext);
        if (null == resolvedAttribute) {
            this.log.debug("{} Attribute definition '{}' produced no attribute", (Object)this.logPrefix, (Object)attributeId);
        } else {
            this.log.debug("{} Attribute definition '{}' produced an attribute with {} values", new Object[]{this.logPrefix, attributeId, resolvedAttribute.getValues().size()});
        }
        workContext.recordAttributeDefinitionResolution(definition, resolvedAttribute);
    }

    protected void resolveDataConnector(@Nonnull String connectorId, @Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
        Map resolvedAttributes;
        Constraint.isNotNull((Object)connectorId, (String)"Data connector ID can not be null");
        Constraint.isNotNull((Object)resolutionContext, (String)"Attribute resolution context cannot be null");
        AttributeResolverWorkContext workContext = (AttributeResolverWorkContext)resolutionContext.getSubcontext(AttributeResolverWorkContext.class, false);
        if (workContext.getResolvedDataConnectors().containsKey(connectorId)) {
            this.log.trace("{} Data connector '{}' was already resolved, nothing to do", (Object)this.logPrefix, (Object)connectorId);
            return;
        }
        DataConnector connector = this.dataConnectors.get(connectorId);
        if (connector == null) {
            this.log.debug("{} No data connector was registered with ID '{}', nothing to do", (Object)this.logPrefix, (Object)connectorId);
            return;
        }
        Instant resolveTime = Instant.now();
        if (connector.getLastFail() != null && resolveTime.isBefore(connector.getLastFail().plus(connector.getNoRetryDelay()))) {
            this.log.debug("{} Data connector '{}' failed to resolve previously, still waiting", (Object)this.logPrefix, (Object)connectorId);
            String failoverDataConnectorId = connector.getFailoverDataConnectorId();
            if (null != failoverDataConnectorId) {
                this.log.debug("{} Data connector '{}' invoking failover data connector '{}'", new Object[]{this.logPrefix, connectorId, failoverDataConnectorId});
                this.resolveDataConnector(failoverDataConnectorId, resolutionContext);
                workContext.recordFailoverResolution(connector, this.dataConnectors.get(failoverDataConnectorId));
                return;
            }
            if (connector.isPropagateResolutionExceptions()) {
                throw new ResolutionException("Connector in no-retry state from previous failure");
            }
            this.log.debug("Data connector '{}' in no-retry state, not configured to propagate failure");
            return;
        }
        this.resolveDependencies((ResolverPlugin<?>)connector, resolutionContext);
        try {
            this.log.debug("{} Resolving data connector {}", (Object)this.logPrefix, (Object)connectorId);
            resolvedAttributes = (Map)connector.resolve(resolutionContext);
        }
        catch (ResolutionException e) {
            String failoverDataConnectorId = connector.getFailoverDataConnectorId();
            if (null != failoverDataConnectorId) {
                if (e instanceof NoResultAnErrorResolutionException) {
                    this.log.debug("{} Data connector '{}' returned no result, invoking failover connector '{}'", new Object[]{this.logPrefix, connectorId, failoverDataConnectorId, e});
                } else {
                    this.log.warn("{} Data connector '{}' failed, invoking failover connector '{}'", new Object[]{this.logPrefix, connectorId, failoverDataConnectorId, e});
                }
                this.resolveDataConnector(failoverDataConnectorId, resolutionContext);
                workContext.recordFailoverResolution(connector, this.dataConnectors.get(failoverDataConnectorId));
                return;
            }
            this.log.warn("{} Data connector '{}' failed", new Object[]{this.logPrefix, connectorId, e});
            throw e;
        }
        if (null != resolvedAttributes) {
            this.log.debug("{} Data connector '{}' resolved the following attributes: {}", new Object[]{this.logPrefix, connectorId, resolvedAttributes.keySet()});
        } else {
            this.log.debug("{} Data connector '{}' produced no attributes", (Object)this.logPrefix, (Object)connectorId);
        }
        workContext.recordDataConnectorResolution(connector, resolvedAttributes);
    }

    protected void resolveDependencies(@Nonnull ResolverPlugin<?> plugin, @Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
        Constraint.isNotNull(plugin, (String)"Plugin dependency can not be null");
        Constraint.isNotNull((Object)resolutionContext, (String)"Attribute resolution context cannot be null");
        this.log.debug("{} Resolving dependencies for '{}'", (Object)this.logPrefix, (Object)plugin.getId());
        for (ResolverAttributeDefinitionDependency attrDependency : plugin.getAttributeDependencies()) {
            this.resolveAttributeDefinition(attrDependency.getDependencyPluginId(), resolutionContext);
        }
        for (ResolverDataConnectorDependency dependency : plugin.getDataConnectorDependencies()) {
            this.resolveDataConnector(dependency.getDependencyPluginId(), resolutionContext);
        }
        this.log.debug("{} Finished resolving dependencies for '{}'", (Object)this.logPrefix, (Object)plugin.getId());
    }

    @Nullable
    @NonnullElements
    private List<IdPAttributeValue> filterAttributeValues(String attributeId, List<IdPAttributeValue> input) {
        this.log.debug("{} De-duping (and null filtering) attribute definition {} result", (Object)this.logPrefix, (Object)attributeId);
        ArrayList<IdPAttributeValue> result = new ArrayList<IdPAttributeValue>(input.size());
        HashSet<IdPAttributeValue> monitor = new HashSet<IdPAttributeValue>(input.size());
        for (IdPAttributeValue value : input) {
            if (this.isStripNulls()) {
                if (null == value) {
                    this.log.debug("{} Stripping null value", (Object)this.logPrefix);
                    continue;
                }
                if (value instanceof EmptyAttributeValue) {
                    this.log.debug("{} Stripping {} value", (Object)this.logPrefix, (Object)((EmptyAttributeValue)value).getValue());
                    continue;
                }
            }
            if (!monitor.add(value)) {
                this.log.debug("{} Removing duplicate value {} of attribute '{}' from resolution result", new Object[]{this.logPrefix, value, attributeId});
                continue;
            }
            result.add(value);
        }
        if (monitor.isEmpty()) {
            return null;
        }
        return result;
    }

    private void collectResolvedAttributes(Map<String, IdPAttribute> resolvedAttributes, AttributeResolverWorkContext workContext, boolean includeDependencyOnly) {
        for (ResolvedAttributeDefinition definition : workContext.getResolvedIdPAttributeDefinitions().values()) {
            IdPAttribute resolvedAttribute = definition.getResolvedAttribute();
            if (null == resolvedAttribute) {
                this.log.debug("{} Removing result of attribute definition '{}', it is null", (Object)this.logPrefix, (Object)definition.getId());
                continue;
            }
            if (definition.isDependencyOnly() && !includeDependencyOnly) {
                this.log.debug("{} Removing result of attribute definition '{}', is marked as dependency only", (Object)this.logPrefix, (Object)definition.getId());
                continue;
            }
            List<IdPAttributeValue> result = this.filterAttributeValues(definition.getId(), resolvedAttribute.getValues());
            if (result == null) {
                this.log.debug("{} Removing result of attribute definition '{}', contains no values", (Object)this.logPrefix, (Object)definition.getId());
                continue;
            }
            resolvedAttribute.setValues(result);
            this.log.debug("{} Attribute '{}' has {} values after post-processing", new Object[]{this.logPrefix, resolvedAttribute.getId(), result.size()});
            resolvedAttributes.put(resolvedAttribute.getId(), resolvedAttribute);
        }
    }

    private void collectExportingDataConnectors(Map<String, IdPAttribute> resolvedAttributes, AttributeResolutionContext resolutionContext, AttributeResolverWorkContext workContext) {
        for (ResolvedDataConnector dataConnector : workContext.getResolvedDataConnectors().values()) {
            Map resolved;
            if (!dataConnector.isExportAllAttributes() && dataConnector.getExportAttributes().isEmpty() || (resolved = dataConnector.getResolvedAttributes()) == null || resolved.isEmpty()) continue;
            for (IdPAttribute attribute : resolved.values()) {
                if (!dataConnector.isExportAllAttributes() && !dataConnector.getExportAttributes().contains(attribute.getId())) continue;
                if (resolvedAttributes.get(attribute.getId()) != null) {
                    this.log.warn("{} could not export attibute '{}' from data connector '{}' since an attribute of that name already exists.", new Object[]{this.logPrefix, attribute.getId(), dataConnector.getId()});
                    continue;
                }
                List<IdPAttributeValue> values = this.filterAttributeValues(attribute.getId(), attribute.getValues());
                if (values == null) {
                    this.log.debug("{} Removing attribute '{}' from data connector '{}' with no values", new Object[]{this.logPrefix, dataConnector.getId(), attribute.getId()});
                    continue;
                }
                IdPAttribute newAttr = new IdPAttribute(attribute.getId());
                newAttr.setValues(values);
                if (!this.isSuppressDisplayInformation()) {
                    dataConnector.addDisplayInformation(resolutionContext, newAttr);
                }
                resolvedAttributes.put(attribute.getId(), newAttr);
            }
        }
    }

    protected void finalizeResolvedAttributes(@Nonnull AttributeResolutionContext resolutionContext) {
        Constraint.isNotNull((Object)resolutionContext, (String)"Attribute resolution context cannot be null");
        AttributeResolverWorkContext workContext = (AttributeResolverWorkContext)resolutionContext.getSubcontext(AttributeResolverWorkContext.class, false);
        LazyMap resolvedAttributes = new LazyMap();
        this.collectResolvedAttributes((Map<String, IdPAttribute>)resolvedAttributes, workContext, false);
        this.collectExportingDataConnectors((Map<String, IdPAttribute>)resolvedAttributes, resolutionContext, workContext);
        resolutionContext.setResolvedIdPAttributes(resolvedAttributes.values());
    }

    protected void finalizePreResolvedAttributes(@Nonnull AttributeResolutionContext resolutionContext) {
        Constraint.isNotNull((Object)resolutionContext, (String)"Attribute resolution context cannot be null");
        AttributeResolverWorkContext workContext = (AttributeResolverWorkContext)resolutionContext.getSubcontext(AttributeResolverWorkContext.class, false);
        LazyMap resolvedAttributes = new LazyMap();
        this.collectResolvedAttributes((Map<String, IdPAttribute>)resolvedAttributes, workContext, true);
        if (resolvedAttributes.isEmpty()) {
            return;
        }
        AttributeContext context = (AttributeContext)resolutionContext.getSubcontext(AttributeContext.class, true);
        this.log.debug("Pre-resolved Attributes: {}", resolvedAttributes.keySet());
        context.setIdPAttributes(resolvedAttributes.values());
        context.setUnfilteredIdPAttributes(resolvedAttributes.values());
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.logPrefix = "Attribute Resolver '" + this.getId() + "':";
        if (null == this.attributeDefinitions) {
            throw new ComponentInitializationException("No Attribute Definitions provided");
        }
        if (null == this.dataConnectors) {
            throw new ComponentInitializationException("No Data Connectors provided");
        }
        this.preRequestedAttributes = this.attributeDefinitions.entrySet().stream().filter(e -> ((AttributeDefinition)e.getValue()).isPreRequested()).map(Map.Entry::getKey).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        HashSet<String> dependencyVerifiedPlugins = new HashSet<String>();
        for (DataConnector dataConnector : this.dataConnectors.values()) {
            this.log.debug("{} Checking if data connector '{}' has a circular dependency", (Object)this.logPrefix, (Object)dataConnector.getId());
            this.checkPlugInDependencies(dataConnector.getId(), (ResolverPlugin<?>)dataConnector, (Set<String>)dependencyVerifiedPlugins);
            if (!(dataConnector instanceof AbstractResolverPlugin)) continue;
            ((AbstractResolverPlugin)dataConnector).setSuppressDisplayInformation(this.isSuppressDisplayInformation());
        }
        for (AttributeDefinition attributeDefinition : this.attributeDefinitions.values()) {
            this.log.debug("{} Checking if attribute definition '{}' has a circular dependency", (Object)this.logPrefix, (Object)attributeDefinition.getId());
            this.checkPlugInDependencies(attributeDefinition.getId(), (ResolverPlugin<?>)attributeDefinition, (Set<String>)dependencyVerifiedPlugins);
            if (!(attributeDefinition instanceof AbstractResolverPlugin)) continue;
            ((AbstractResolverPlugin)attributeDefinition).setSuppressDisplayInformation(this.isSuppressDisplayInformation());
        }
    }

    protected void checkPlugInDependencies(String circularCheckPluginId, ResolverPlugin<?> plugin, Set<String> checkedPlugins) throws ComponentInitializationException {
        String pluginId = plugin.getId();
        for (ResolverAttributeDefinitionDependency attrDependency : plugin.getAttributeDependencies()) {
            if (checkedPlugins.contains(pluginId)) continue;
            if (circularCheckPluginId.equals(attrDependency.getDependencyPluginId())) {
                throw new ComponentInitializationException(this.logPrefix + " Plugin '" + circularCheckPluginId + "' and attribute definition '" + attrDependency.getDependencyPluginId() + "' have a circular dependency on each other.");
            }
            AttributeDefinition dependencyAttribute = this.attributeDefinitions.get(attrDependency.getDependencyPluginId());
            if (dependencyAttribute == null) {
                throw new ComponentInitializationException(this.logPrefix + " Plugin '" + plugin.getId() + "' has a dependency on attribute definition '" + attrDependency.getDependencyPluginId() + "' which doesn't exist");
            }
            this.checkPlugInDependencies(circularCheckPluginId, (ResolverPlugin<?>)dependencyAttribute, checkedPlugins);
            checkedPlugins.add(pluginId);
        }
        for (ResolverDataConnectorDependency dependency : plugin.getDataConnectorDependencies()) {
            if (checkedPlugins.contains(pluginId)) continue;
            if (circularCheckPluginId.equals(dependency.getDependencyPluginId())) {
                throw new ComponentInitializationException(this.logPrefix + " Plugin '" + circularCheckPluginId + "' and data connector '" + dependency.getDependencyPluginId() + "' have a circular dependency on each other.");
            }
            ResolverPlugin dependencyDataConnector = (ResolverPlugin)this.dataConnectors.get(dependency.getDependencyPluginId());
            if (dependencyDataConnector == null) {
                throw new ComponentInitializationException(this.logPrefix + " Plugin '" + plugin.getId() + "' has a dependency on data connector '" + dependency.getDependencyPluginId() + "' which doesn't exist");
            }
            this.checkPlugInDependencies(circularCheckPluginId, dependencyDataConnector, checkedPlugins);
            checkedPlugins.add(pluginId);
        }
    }

    @Nonnull
    public AttributeResolver getComponent() {
        return this;
    }

    private boolean startTimer(@Nonnull AttributeResolutionContext resolutionContext) {
        MetricContext timerCtx;
        BaseContext prc = (BaseContext)this.profileContextStrategy.apply(resolutionContext);
        if (prc != null && (timerCtx = (MetricContext)prc.getSubcontext(MetricContext.class)) != null) {
            timerCtx.start(this.getId());
            return true;
        }
        return false;
    }

    private void stopTimer(@Nonnull AttributeResolutionContext resolutionContext) {
        MetricContext timerCtx;
        BaseContext prc = (BaseContext)this.profileContextStrategy.apply(resolutionContext);
        if (prc != null && (timerCtx = (MetricContext)prc.getSubcontext(MetricContext.class)) != null) {
            timerCtx.stop(this.getId());
        }
    }
}

