/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import com.google.common.base.Predicates;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.DateTimeAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DateTimeAttributeDefinition
extends AbstractAttributeDefinition {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DateTimeAttributeDefinition.class);
    @Nullable
    private DateTimeFormatter formatter;
    private boolean epochInSeconds = true;
    private boolean ignoreConversionErrors;

    public void setEpochInSeconds(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.epochInSeconds = flag;
    }

    public boolean isEpochInSeconds() {
        return this.epochInSeconds;
    }

    public void setIgnoreConversionErrors(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.ignoreConversionErrors = flag;
    }

    public boolean isIgnoreConversionErrors() {
        return this.ignoreConversionErrors;
    }

    public void setDateTimeFormatter(@Nullable DateTimeFormatter f) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.formatter = f;
    }

    @Nullable
    public DateTimeFormatter getDateTimeFormatter() {
        return this.formatter;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getDataConnectorDependencies().isEmpty() && this.getAttributeDependencies().isEmpty()) {
            throw new ComponentInitializationException(this.getLogPrefix() + " no dependencies were configured");
        }
    }

    @Nonnull
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        Constraint.isNotNull((Object)workContext, (String)"AttributeResolverWorkContext cannot be null");
        IdPAttribute result = new IdPAttribute(this.getId());
        List values = PluginDependencySupport.getMergedAttributeValues((AttributeResolverWorkContext)workContext, (Collection)this.getAttributeDependencies(), (Collection)this.getDataConnectorDependencies(), (String)this.getId());
        List converted = values.stream().map(v -> this.convert((IdPAttributeValue)v)).filter((Predicate<DateTimeAttributeValue>)Predicates.notNull()).collect(Collectors.toUnmodifiableList());
        if (!this.ignoreConversionErrors && converted.size() != values.size()) {
            throw new ResolutionException("Unable to convert all inputs to date/time values.");
        }
        result.setValues(converted);
        return result;
    }

    @Nullable
    protected DateTimeAttributeValue convert(@Nonnull IdPAttributeValue input) {
        if (input instanceof DateTimeAttributeValue) {
            return (DateTimeAttributeValue)input;
        }
        if (!(input instanceof StringAttributeValue)) {
            this.log.info("{} Ignoring unsupported IdPAttributeValue type: {}", (Object)this.getLogPrefix(), (Object)input.getClass().getName());
            return null;
        }
        String stringValue = ((StringAttributeValue)input).getValue();
        try {
            Long longValue = Long.valueOf(stringValue);
            return new DateTimeAttributeValue(this.epochInSeconds ? Instant.ofEpochSecond(longValue) : Instant.ofEpochMilli(longValue));
        }
        catch (DateTimeException e) {
            this.log.info("{} Epoch value was out of range", (Object)this.getLogPrefix(), (Object)e);
            return null;
        }
        catch (NumberFormatException e) {
            if (this.formatter == null) {
                this.log.info("{} No DateTimeFormatter installed, unable to convert string value", (Object)this.getLogPrefix());
                return null;
            }
            try {
                return new DateTimeAttributeValue(this.formatter.parse((CharSequence)stringValue, Instant::from));
            }
            catch (DateTimeException e2) {
                this.log.info("{} Error converting input value '{}' into Instant", new Object[]{this.getLogPrefix(), stringValue, e2});
                return null;
            }
        }
    }
}

