/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;

@ThreadSafe
public class SimpleAttributeDefinition
extends AbstractAttributeDefinition {
    private boolean stripNulls;

    public void setStripNulls(boolean what) {
        this.stripNulls = what;
    }

    public boolean isStripNulls() {
        return this.stripNulls;
    }

    @Nonnull
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        Constraint.isNotNull((Object)workContext, (String)"AttributeResolverWorkContext cannot be null");
        IdPAttribute result = new IdPAttribute(this.getId());
        List values = PluginDependencySupport.getMergedAttributeValues((AttributeResolverWorkContext)workContext, (Collection)this.getAttributeDependencies(), (Collection)this.getDataConnectorDependencies(), (String)this.getId());
        if (this.isStripNulls()) {
            result.setValues((Collection)values.stream().filter(e -> e != null && !(e instanceof EmptyAttributeValue)).collect(Collectors.toUnmodifiableList()));
        } else {
            result.setValues((Collection)values);
        }
        return result;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getDataConnectorDependencies().isEmpty() && this.getAttributeDependencies().isEmpty()) {
            throw new ComponentInitializationException(this.getLogPrefix() + " no dependencies were configured");
        }
    }
}

