/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.http.impl;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.http.impl.AbstractHTTPSearchBuilder;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplatedURLBuilder
extends AbstractHTTPSearchBuilder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TemplatedURLBuilder.class);
    @NonnullAfterInit
    private Template template;
    @NonnullAfterInit
    private String templateText;
    @NonnullAfterInit
    private VelocityEngine engine;
    @Nonnull
    private final Escaper paramEscaper = UrlEscapers.urlFormParameterEscaper();
    @Nonnull
    private final Escaper fragmentEscaper = UrlEscapers.urlFragmentEscaper();
    @Nonnull
    private final Escaper pathEscaper = UrlEscapers.urlPathSegmentEscaper();
    @Nullable
    private Object customObject;

    @NonnullAfterInit
    public Template getTemplate() {
        return this.template;
    }

    @NonnullAfterInit
    public String getTemplateText() {
        return this.templateText;
    }

    public void setTemplateText(@Nullable String text) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.templateText = StringSupport.trimOrNull((String)text);
    }

    @NonnullAfterInit
    public VelocityEngine getVelocityEngine() {
        return this.engine;
    }

    public void setVelocityEngine(@Nonnull VelocityEngine velocityEngine) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.engine = (VelocityEngine)Constraint.isNotNull((Object)velocityEngine, (String)"Velocity engine cannot be null");
    }

    public void setCustomObject(@Nullable Object object) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.customObject = object;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.engine) {
            throw new ComponentInitializationException("Velocity engine cannot be null");
        }
        if (null == this.templateText) {
            throw new ComponentInitializationException("Template text cannot be null");
        }
        this.template = Template.fromTemplate((VelocityEngine)this.engine, (String)this.templateText);
    }

    @Nonnull
    @NotEmpty
    protected String merge(@Nonnull VelocityContext context) {
        String result = this.template.merge((Context)context);
        this.log.debug("Template text {} yields {}", (Object)this.templateText, (Object)result);
        return result;
    }

    @Override
    @Nonnull
    protected String getURL(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) throws ResolutionException {
        VelocityContext context = new VelocityContext();
        this.log.trace("Creating request URL using attribute resolution context {}", (Object)resolutionContext);
        context.put("resolutionContext", (Object)resolutionContext);
        context.put("httpClientSecurityParameters", (Object)this.getHttpClientSecurityParameters());
        context.put("paramEscaper", (Object)this.paramEscaper);
        context.put("fragmentEscaper", (Object)this.fragmentEscaper);
        context.put("pathEscaper", (Object)this.pathEscaper);
        context.put("custom", this.customObject);
        if (dependencyAttributes != null && !dependencyAttributes.isEmpty()) {
            for (Map.Entry<String, List<IdPAttributeValue>> entry : dependencyAttributes.entrySet()) {
                ArrayList<Object> values = new ArrayList<Object>(entry.getValue().size());
                for (IdPAttributeValue value : entry.getValue()) {
                    values.add(value.getNativeValue());
                }
                this.log.trace("Adding dependency {} to context with {} value(s)", (Object)entry.getKey(), (Object)values.size());
                context.put(entry.getKey(), values);
            }
        }
        try {
            return this.merge(context);
        }
        catch (VelocityException e) {
            this.log.error("Error running template engine: {}", (Object)e.getMessage());
            throw new ResolutionException("Error running template engine", (Exception)((Object)e));
        }
    }
}

