/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.ldap.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.resolver.dc.ValidationException;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactoryValidator
implements Validator {
    private final Logger log = LoggerFactory.getLogger(ConnectionFactoryValidator.class);
    @Nonnull
    private ConnectionFactory connectionFactory;
    private boolean throwOnValidateError;

    @Nonnull
    public void setConnectionFactory(@Nonnull ConnectionFactory factory) {
        this.connectionFactory = (ConnectionFactory)Constraint.isNotNull((Object)factory, (String)"Connection factory must be non-null");
    }

    @Nonnull
    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setThrowValidateError(boolean what) {
        this.throwOnValidateError = what;
    }

    public boolean isThrowValidateError() {
        return this.throwOnValidateError;
    }

    public void validate() throws ValidationException {
        if (this.connectionFactory == null) {
            this.log.error("No connection factory installed");
            if (this.isThrowValidateError()) {
                throw new ValidationException("Connection factory is not set");
            }
        } else {
            assert (this.connectionFactory != null);
            try (Connection connection = null;){
                connection = this.connectionFactory.getConnection();
                if (connection == null) {
                    this.log.error("Unable to retrieve connections from configured connection factory");
                    if (this.isThrowValidateError()) {
                        throw new LdapException("Unable to retrieve connection from connection factory");
                    }
                } else {
                    connection.open();
                }
            }
        }
    }
}

