/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.rdbms.impl;

import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import net.shibboleth.idp.attribute.resolver.dc.ValidationException;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceValidator
implements Validator {
    private final Logger log = LoggerFactory.getLogger(DataSourceValidator.class);
    @NonnullAfterInit
    private DataSource dataSource;
    private boolean throwOnValidateError;

    public void setDataSource(@Nonnull DataSource source) {
        this.dataSource = (DataSource)Constraint.isNotNull((Object)source, (String)"Data Source should not be null");
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setThrowValidateError(boolean value) {
        this.throwOnValidateError = value;
    }

    public boolean isThrowValidateError() {
        return this.throwOnValidateError;
    }

    /*
     * Loose catch block
     */
    public void validate() throws ValidationException {
        block20: {
            Connection connection;
            if (this.dataSource == null) {
                this.log.error("No datasource installed");
                if (this.isThrowValidateError()) {
                    throw new ValidationException("Datasource is not set");
                }
            } else {
                block19: {
                    assert (this.dataSource != null);
                    connection = null;
                    connection = this.dataSource.getConnection();
                    if (connection != null) break block19;
                    this.log.error("Unable to retrieve connections from configured data source");
                    if (!this.isThrowValidateError()) break block19;
                    throw new ValidationException("Unable to retrieve connections from configured data source");
                }
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                    break block20;
                }
                catch (SQLException e) {
                    this.log.error("Error closing database connection; SQL State: {}, SQL Code: {}", new Object[]{e.getSQLState(), e.getErrorCode(), e});
                }
            }
            break block20;
            catch (SQLException e) {
                block21: {
                    try {
                        if (e.getSQLState() != null) {
                            this.log.error("Datasource validation failed with SQL state: {}, SQL Code: {}", new Object[]{e.getSQLState(), e.getErrorCode(), e});
                        } else {
                            this.log.error("Datasource validation failed", (Throwable)e);
                        }
                        if (!this.isThrowValidateError()) break block21;
                        throw new ValidationException("Invalid connector configuration", (Exception)e);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (connection != null && !connection.isClosed()) {
                                connection.close();
                            }
                        }
                        catch (SQLException e2) {
                            this.log.error("Error closing database connection; SQL State: {}, SQL Code: {}", new Object[]{e2.getSQLState(), e2.getErrorCode(), e2});
                        }
                        throw throwable;
                    }
                }
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
                catch (SQLException e3) {
                    this.log.error("Error closing database connection; SQL State: {}, SQL Code: {}", new Object[]{e3.getSQLState(), e3.getErrorCode(), e3});
                }
            }
        }
    }
}

