/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.rdbms.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.dc.ValidationException;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.idp.attribute.resolver.dc.impl.AbstractSearchDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.ExecutableStatement;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.ResultMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.StringResultMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.DataSourceValidator;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBMSDataConnector
extends AbstractSearchDataConnector<ExecutableStatement, ResultMappingStrategy> {
    private final Logger log = LoggerFactory.getLogger(RDBMSDataConnector.class);
    private DataSource dataSource;
    private boolean defaultValidator = true;
    private boolean defaultMappingStrategy = true;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(@Nonnull DataSource source) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.dataSource = (DataSource)Constraint.isNotNull((Object)source, (String)"JDBC data source can not be null");
    }

    @Override
    public void setValidator(@Nonnull Validator validator) {
        super.setValidator(validator);
        if (validator instanceof DataSourceValidator && this.dataSource != null) {
            ((DataSourceValidator)validator).setDataSource(this.dataSource);
        }
        this.defaultValidator = false;
    }

    @Override
    public void setMappingStrategy(@Nonnull ResultMappingStrategy strategy) {
        super.setMappingStrategy(strategy);
        this.defaultMappingStrategy = false;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        if (this.dataSource == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " no data source was configured");
        }
        if (this.defaultValidator) {
            DataSourceValidator validator = new DataSourceValidator();
            validator.setDataSource(this.dataSource);
            super.setValidator(validator);
        }
        if (this.defaultMappingStrategy) {
            super.setMappingStrategy(new StringResultMappingStrategy());
        }
        super.doInitialize();
        boolean throwValidateError = this.getValidator().isThrowValidateError();
        try {
            this.getValidator().setThrowValidateError(this.isFailFastInitialize());
            this.getValidator().validate();
        }
        catch (ValidationException e) {
            this.log.error("{} Invalid connector configuration", (Object)this.getLogPrefix(), (Object)e);
            if (this.isFailFastInitialize()) {
                throw new ComponentInitializationException(this.getLogPrefix() + " Invalid connector configuration", (Exception)((Object)e));
            }
        }
        finally {
            this.getValidator().setThrowValidateError(throwValidateError);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    @Nullable
    protected Map<String, IdPAttribute> retrieveAttributes(ExecutableStatement statement) throws ResolutionException {
        Map map;
        ResultSet queryResult;
        Connection connection;
        block17: {
            if (statement == null) {
                throw new ResolutionException("Executable statement cannot be null");
            }
            connection = null;
            connection = this.dataSource.getConnection();
            queryResult = statement.execute(connection);
            this.log.trace("Data connector '{}': search returned {}", (Object)this.getId(), (Object)queryResult);
            map = ((ResultMappingStrategy)this.getMappingStrategy()).map((Object)queryResult);
            if (queryResult == null) break block17;
            queryResult.close();
        }
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException e) {
            this.log.debug("{} Unable to close database connection; SQL State: {}, SQL Code: {}", (Object)new Object[]{this.getLogPrefix(), e.getSQLState(), e.getErrorCode()}, (Object)e);
        }
        return map;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (queryResult != null) {
                            try {
                                queryResult.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new ResolutionException(this.getLogPrefix() + " Unable to execute SQL query", (Exception)e);
                    }
                }
                catch (Throwable throwable3) {
                    try {
                        if (connection != null && !connection.isClosed()) {
                            connection.close();
                        }
                    }
                    catch (SQLException e) {
                        this.log.debug("{} Unable to close database connection; SQL State: {}, SQL Code: {}", (Object)new Object[]{this.getLogPrefix(), e.getSQLState(), e.getErrorCode()}, (Object)e);
                    }
                    throw throwable3;
                }
            }
        }
    }
}

