/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.impl;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImpl;
import net.shibboleth.idp.metrics.ReloadableServiceGaugeSet;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeResolverServiceGaugeSet
extends ReloadableServiceGaugeSet<AttributeResolver>
implements MetricSet,
MetricFilter {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeResolverServiceGaugeSet.class);

    public AttributeResolverServiceGaugeSet(@Nonnull @ParameterName(name="metricName") @NotEmpty String metricName) {
        super(metricName);
        this.getMetricMap().put(MetricRegistry.name((String)"net.shibboleth.idp", (String[])new String[]{metricName, "success"}), new Gauge<Map<String, Instant>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Map<String, Instant> getValue() {
                HashMap<String, Instant> mapBuilder = new HashMap<String, Instant>();
                ServiceableComponent component = AttributeResolverServiceGaugeSet.this.getService().getServiceableComponent();
                if (component != null) {
                    try {
                        Object resolver = component.getComponent();
                        if (resolver instanceof AttributeResolverImpl) {
                            Collection<DataConnector> connectors = ((AttributeResolverImpl)((Object)resolver)).getDataConnectors().values();
                            for (DataConnector connector : connectors) {
                                if (connector.getLastSuccess() == null) continue;
                                mapBuilder.put(connector.getId(), connector.getLastSuccess());
                            }
                        } else if (resolver instanceof AttributeResolver) {
                            AttributeResolverServiceGaugeSet.this.log.debug("{}: Cannot get Data Connector success  information from unsupported class type {}", (Object)AttributeResolverServiceGaugeSet.this.getLogPrefix(), resolver.getClass());
                        } else {
                            AttributeResolverServiceGaugeSet.this.log.warn("{}: Injected Service was not for an AttributeResolver ({})", (Object)AttributeResolverServiceGaugeSet.this.getLogPrefix(), resolver.getClass());
                        }
                    }
                    finally {
                        component.unpinComponent();
                    }
                }
                return Map.copyOf(mapBuilder);
            }
        });
        this.getMetricMap().put(MetricRegistry.name((String)"net.shibboleth.idp", (String[])new String[]{metricName, "failure"}), new Gauge<Map<String, Instant>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Map<String, Instant> getValue() {
                HashMap<String, Instant> mapBuilder = new HashMap<String, Instant>();
                ServiceableComponent component = AttributeResolverServiceGaugeSet.this.getService().getServiceableComponent();
                if (component != null) {
                    try {
                        Object resolver = component.getComponent();
                        if (resolver instanceof AttributeResolverImpl) {
                            Collection<DataConnector> connectors = ((AttributeResolverImpl)((Object)resolver)).getDataConnectors().values();
                            for (DataConnector connector : connectors) {
                                if (connector.getLastFail() == null) continue;
                                mapBuilder.put(connector.getId(), connector.getLastFail());
                            }
                        } else if (resolver instanceof AttributeResolver) {
                            AttributeResolverServiceGaugeSet.this.log.debug("{}: Cannot get Data Connector failure  information from unsupported class type {}", (Object)AttributeResolverServiceGaugeSet.this.getLogPrefix(), resolver.getClass());
                        } else {
                            AttributeResolverServiceGaugeSet.this.log.warn("{}: Injected Service was not for an AttributeResolver ({})", (Object)AttributeResolverServiceGaugeSet.this.getLogPrefix(), resolver.getClass());
                        }
                    }
                    finally {
                        component.unpinComponent();
                    }
                }
                return Map.copyOf(mapBuilder);
            }
        });
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        ServiceableComponent component = this.getService().getServiceableComponent();
        if (component != null) {
            try {
                if (component.getComponent() instanceof AttributeResolver) {
                    return;
                }
                this.log.error("{}: Injected service was not for an AttributeResolver ({})", (Object)this.getLogPrefix(), component.getClass());
                throw new ComponentInitializationException("Injected service was not for an AttributeResolver");
            }
            finally {
                component.unpinComponent();
            }
        }
    }
}

