/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.attribute.resolver.spring.ResolverPluginDependencyParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseResolverPluginParser
extends AbstractSingleBeanDefinitionParser {
    private String defnId = "<Unnamed Attribute or Connector>";
    private final Logger log = LoggerFactory.getLogger(BaseResolverPluginParser.class);

    @Nonnull
    protected String getDefinitionId() {
        return this.defnId;
    }

    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        String id = StringSupport.trimOrNull((String)config.getAttributeNS(null, "id"));
        this.log.info("Parsing configuration for {} plugin with id : {}", (Object)config.getLocalName(), (Object)id);
        builder.addPropertyValue("id", (Object)id);
        if (null != id) {
            this.defnId = id;
        }
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
        if (config.hasAttributeNS(null, "activationConditionRef")) {
            builder.addPropertyReference("activationCondition", config.getAttributeNS(null, "activationConditionRef"));
        }
        if (config.hasAttributeNS(null, "profileContextStrategyRef")) {
            builder.addPropertyReference("profileContextStrategy", config.getAttributeNS(null, "profileContextStrategyRef"));
        }
        List dependencyElements = ElementSupport.getChildElements((Node)config, (QName)ResolverPluginDependencyParser.ELEMENT_NAME);
        builder.addPropertyValue("dependencies", (Object)SpringSupport.parseCustomElements((Collection)dependencyElements, (ParserContext)parserContext));
    }
}

