/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.ad;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.spring.ad.BaseAttributeDefinitionParser;
import net.shibboleth.idp.saml.attribute.resolver.impl.SAML1NameIdentifierAttributeDefinition;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SAML1NameIdentifierAttributeDefinitionParser
extends BaseAttributeDefinitionParser {
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver:ad", "SAML1NameIdentifier");
    private final Logger log = LoggerFactory.getLogger(SAML1NameIdentifierAttributeDefinitionParser.class);

    protected Class<SAML1NameIdentifierAttributeDefinition> getBeanClass(@Nullable Element element) {
        return SAML1NameIdentifierAttributeDefinition.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        String nameIdFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        if (config.hasAttributeNS(null, "nameIdFormat")) {
            nameIdFormat = StringSupport.trimOrNull((String)config.getAttributeNS(null, "nameIdFormat"));
        }
        String nameIdQualifier = StringSupport.trimOrNull((String)config.getAttributeNS(null, "nameIdQualifier"));
        this.log.debug("{} nameIdFormat '{}', nameIdQualifier '{}'.", new Object[]{this.getLogPrefix(), nameIdFormat, nameIdQualifier});
        builder.addPropertyValue("nameIdFormat", (Object)nameIdFormat);
        builder.addPropertyValue("nameIdQualifier", (Object)nameIdQualifier);
    }
}

