/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.ad;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.ad.impl.ScriptedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.spring.ad.BaseAttributeDefinitionParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScriptedAttributeDefinitionParser
extends BaseAttributeDefinitionParser {
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver:ad", "Script");
    public static final QName SCRIPT_FILE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver:ad", "ScriptFile");
    public static final QName SCRIPT_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver:ad", "Script");
    private final Logger log = LoggerFactory.getLogger(ScriptedAttributeDefinitionParser.class);

    protected Class<ScriptedAttributeDefinition> getBeanClass(@Nullable Element element) {
        return ScriptedAttributeDefinition.class;
    }

    @Nonnull
    private String getScript(Element config) {
        String script = null;
        List scriptElem = ElementSupport.getChildElements((Node)config, (QName)SCRIPT_ELEMENT_NAME);
        List scriptFileElem = ElementSupport.getChildElements((Node)config, (QName)SCRIPT_FILE_ELEMENT_NAME);
        if (scriptElem != null && scriptElem.size() > 0) {
            if (scriptFileElem != null && scriptFileElem.size() > 0) {
                this.log.info("Attribute definition {}: definition contains both <Script> and <ScriptFile> elements, taking the <Script> element", (Object)this.getDefinitionId());
            }
            script = ((Element)scriptElem.get(0)).getTextContent();
        } else if (scriptFileElem != null && scriptFileElem.size() > 0) {
            String scriptFile = ((Element)scriptFileElem.get(0)).getTextContent();
            try {
                script = StringSupport.inputStreamToString((InputStream)new FileInputStream(scriptFile), null);
            }
            catch (IOException e) {
                throw new BeanCreationException("Attribute definition " + this.getDefinitionId() + ": Unable to read script file " + scriptFile, (Throwable)e);
            }
        }
        if (script == null) {
            throw new BeanCreationException("No script specified for this attribute definition");
        }
        return script;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        String scriptLanguage = "javascript";
        if (config.hasAttributeNS(null, "language")) {
            scriptLanguage = config.getAttributeNS(null, "language");
        }
        this.log.debug("{} scripting language: {}.", (Object)this.getLogPrefix(), (Object)scriptLanguage);
        String script = this.getScript(config);
        this.log.debug("{} script: {}.", (Object)this.getLogPrefix(), (Object)script);
        BeanDefinitionBuilder scriptBuilder = BeanDefinitionBuilder.genericBeanDefinition(EvaluableScript.class);
        scriptBuilder.addConstructorArgValue((Object)scriptLanguage);
        scriptBuilder.addConstructorArgValue((Object)script);
        builder.addPropertyValue("script", (Object)scriptBuilder.getBeanDefinition());
    }
}

