/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.ad;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.ad.impl.TemplateAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.spring.ad.BaseAttributeDefinitionParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TemplateAttributeDefinitionParser
extends BaseAttributeDefinitionParser {
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver:ad", "Template");
    public static final QName TEMPLATE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver:ad", "Template");
    public static final QName SOURCE_ATTRIBUTE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver:ad", "SourceAttribute");
    private final Logger log = LoggerFactory.getLogger(TemplateAttributeDefinitionParser.class);

    protected Class<TemplateAttributeDefinition> getBeanClass(@Nullable Element element) {
        return TemplateAttributeDefinition.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        String velocityEngineRef;
        List sourceAttributeElements;
        super.doParse(config, parserContext, builder);
        List templateElements = ElementSupport.getChildElements((Node)config, (QName)TEMPLATE_ELEMENT_NAME);
        if (null != templateElements && templateElements.size() >= 1) {
            String templateText = StringSupport.trimOrNull((String)((Element)templateElements.get(0)).getTextContent());
            this.log.debug("{} template is '{}'", (Object)this.getLogPrefix(), (Object)templateText);
            builder.addPropertyValue("templateText", (Object)templateText);
        }
        if (null != (sourceAttributeElements = ElementSupport.getChildElements((Node)config, (QName)SOURCE_ATTRIBUTE_ELEMENT_NAME))) {
            ManagedList sourceAttributes = new ManagedList(sourceAttributeElements.size());
            for (Element element : sourceAttributeElements) {
                sourceAttributes.add(StringSupport.trimOrNull((String)element.getTextContent()));
            }
            this.log.debug("{} source attributes are '{}'.", (Object)this.getLogPrefix(), (Object)sourceAttributes);
            builder.addPropertyValue("sourceAttributes", (Object)sourceAttributes);
        }
        if (null == (velocityEngineRef = StringSupport.trimOrNull((String)config.getAttributeNS(null, "velocityEngine")))) {
            velocityEngineRef = "shibboleth.VelocityEngine";
        }
        this.log.debug("{} velocity engine reference '{}'.", (Object)this.getLogPrefix(), (Object)velocityEngineRef);
        builder.addPropertyReference("velocityEngine", velocityEngineRef);
    }
}

