/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.ad.mapped;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.attribute.resolver.ad.mapped.impl.ValueMap;
import net.shibboleth.idp.attribute.resolver.spring.ad.mapped.SourceValueParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ValueMapParser
extends AbstractSingleBeanDefinitionParser {
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver:ad", "ValueMap");
    public static final QName RETURN_VALUE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver:ad", "ReturnValue");
    private Logger log = LoggerFactory.getLogger(ValueMapParser.class);

    protected Class<ValueMap> getBeanClass(@Nullable Element element) {
        return ValueMap.class;
    }

    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        List returnElems = ElementSupport.getChildElements((Node)config, (QName)RETURN_VALUE_ELEMENT_NAME);
        String returnValue = null;
        if (null != returnElems && returnElems.size() > 0) {
            returnValue = StringSupport.trimOrNull((String)((Element)returnElems.get(0)).getTextContent());
        }
        if (null == returnValue) {
            throw new BeanCreationException("Attribute Definition: ValueMap must have a ReturnValue");
        }
        List sourceValueElements = ElementSupport.getChildElements((Node)config, (QName)SourceValueParser.TYPE_NAME);
        if (null == sourceValueElements || sourceValueElements.size() == 0) {
            throw new BeanCreationException("Attribute Definition: ValueMap must have at least one SourceValue");
        }
        ManagedList sourceValues = SpringSupport.parseCustomElements((Collection)sourceValueElements, (ParserContext)parserContext);
        this.log.debug("AttributeDefinition(ValueMap): return value: {}, {} source values ", (Object)returnValue, (Object)sourceValues.size());
        this.log.trace("AttributeDefinition(ValueMap): source values: {}", (Object)sourceValues);
        builder.addPropertyValue("sourceValues", (Object)sourceValues);
        builder.addPropertyValue("returnValue", (Object)returnValue);
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

