/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.spring.BaseResolverPluginParser;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractDataConnectorParser
extends BaseResolverPluginParser {
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "DataConnector");
    public static final QName FAILOVER_DATA_CONNECTOR_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "FailoverDataConnector");
    private String logPrefix;
    private final Logger log = LoggerFactory.getLogger(AbstractDataConnectorParser.class);

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        List failoverConnector = ElementSupport.getChildElements((Node)config, (QName)FAILOVER_DATA_CONNECTOR_ELEMENT_NAME);
        if (failoverConnector != null && !failoverConnector.isEmpty()) {
            String connectorId = StringSupport.trimOrNull((String)((Element)failoverConnector.get(0)).getAttributeNS(null, "ref"));
            this.log.debug("{} setting the following failover data connector dependencies {}", (Object)this.getLogPrefix(), (Object)connectorId);
            builder.addPropertyValue("failoverDataConnectorId", (Object)connectorId);
        }
    }

    @Nonnull
    protected BeanFactory createBeanFactory(String ... springResources) {
        GenericApplicationContext ctx = new GenericApplicationContext();
        XmlBeanDefinitionReader definitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ctx);
        definitionReader.setValidationMode(3);
        definitionReader.setNamespaceAware(true);
        definitionReader.loadBeanDefinitions(springResources);
        ctx.refresh();
        return ctx.getBeanFactory();
    }

    @Nullable
    protected PropertyDescriptor[] getBeanPropertyDescriptors(@Nonnull Class<? extends AbstractDataConnector> connectorClass) {
        PropertyDescriptor[] descriptors = null;
        try {
            BeanInfo info = Introspector.getBeanInfo(connectorClass, AbstractDataConnector.class);
            descriptors = info.getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            this.log.error("could not retrieve bean info for class {}", connectorClass, (Object)e);
        }
        return descriptors;
    }

    protected void addPropertyDescriptorValues(@Nonnull BeanDefinitionBuilder builder, @Nonnull BeanFactory beanFactory, @Nonnull Class<? extends AbstractDataConnector> connectorClass) {
        for (PropertyDescriptor descriptor : this.getBeanPropertyDescriptors(connectorClass)) {
            this.log.debug("parsing property descriptor {}", (Object)descriptor);
            Object value = SpringSupport.getBean((BeanFactory)beanFactory, descriptor.getPropertyType());
            if (value != null) {
                builder.addPropertyValue(descriptor.getName(), value);
                this.log.debug("added property value {}", value);
                continue;
            }
            this.log.debug("no configuration found for {}", descriptor.getPropertyType());
        }
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        if (null == this.logPrefix) {
            StringBuilder builder = new StringBuilder("Data Connector '").append(this.getDefinitionId()).append("':");
            this.logPrefix = builder.toString();
        }
        return this.logPrefix;
    }
}

