/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.resolver.spring.dc.AbstractDataConnectorParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class BaseComputedIDDataConnectorParser
extends AbstractDataConnectorParser {
    private final Logger log = LoggerFactory.getLogger(BaseComputedIDDataConnectorParser.class);

    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder, @Nullable String generatedIdDefaultName) {
        byte[] saltBytes;
        super.doParse(config, parserContext, builder);
        String generatedAttribute = config.hasAttributeNS(null, "generatedAttributeID") ? config.getAttributeNS(null, "generatedAttributeID") : generatedIdDefaultName;
        String sourceAttribute = config.getAttributeNS(null, "sourceAttributeID");
        String salt = StringSupport.trimOrNull((String)config.getAttributeNS(null, "salt"));
        if (null == salt) {
            saltBytes = null;
            this.log.debug("{} generated Attribute : '{}', sourceAttribute = '{}', no salt provided.", new Object[]{this.getLogPrefix(), generatedAttribute, sourceAttribute});
        } else {
            saltBytes = salt.getBytes();
            this.log.debug("{} generated Attribute : '{}', sourceAttribute = '{}', salt: '{}'.", new Object[]{this.getLogPrefix(), generatedAttribute, sourceAttribute, saltBytes});
        }
        builder.addPropertyValue("generatedAttributeId", (Object)generatedAttribute);
        builder.addPropertyValue("sourceAttributeId", (Object)sourceAttribute);
        builder.addPropertyValue("salt", (Object)saltBytes);
    }
}

