/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CacheConfigParser {
    private final Element configElement;

    public CacheConfigParser(@Nonnull Element config) {
        Constraint.isNotNull((Object)config, (String)"Element cannot be null");
        this.configElement = config;
    }

    @Nonnull
    public BeanDefinition createCache() {
        String defaultCache = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("cacheResults"));
        String timeToLive = null;
        String maximumSize = null;
        Element cacheElement = ElementSupport.getFirstChildElement((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "ResultCache"));
        if (cacheElement != null) {
            timeToLive = AttributeSupport.getAttributeValue((Element)cacheElement, (QName)new QName("elementTimeToLive"));
            maximumSize = AttributeSupport.getAttributeValue((Element)cacheElement, (QName)new QName("maximumCachedElements"));
        }
        BeanDefinitionBuilder cache = BeanDefinitionBuilder.rootBeanDefinition(CacheConfigParser.class, (String)"buildCache");
        cache.addConstructorArgValue((Object)defaultCache);
        cache.addConstructorArgValue((Object)timeToLive);
        cache.addConstructorArgValue((Object)maximumSize);
        return cache.getBeanDefinition();
    }

    @Nullable
    public static Cache<String, Map<String, IdPAttribute>> buildCache(String defaultCache, String timeToLive, String maximumSize) {
        if (Boolean.valueOf(defaultCache).booleanValue()) {
            return CacheBuilder.newBuilder().maximumSize(500L).expireAfterAccess(4L, TimeUnit.HOURS).build();
        }
        if (timeToLive != null && maximumSize != null) {
            return CacheBuilder.newBuilder().maximumSize(Long.parseLong(maximumSize)).expireAfterAccess(DOMTypeSupport.durationToLong((String)timeToLive), TimeUnit.MILLISECONDS).build();
        }
        return null;
    }
}

