/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc;

import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.dc.impl.StaticDataConnector;
import net.shibboleth.idp.attribute.resolver.spring.dc.AbstractDataConnectorParser;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StaticDataConnectorParser
extends AbstractDataConnectorParser {
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver:dc", "Static");
    public static final QName ATTRIBUTE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver:dc", "Attribute");
    private final Logger log = LoggerFactory.getLogger(StaticDataConnectorParser.class);

    protected Class<StaticDataConnector> getBeanClass(Element element) {
        return StaticDataConnector.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        List children = ElementSupport.getChildElements((Node)config, (QName)ATTRIBUTE_ELEMENT_NAME);
        ManagedList attributes = new ManagedList(children.size());
        for (Element child : children) {
            String attrId = child.getAttributeNS(null, "id");
            BeanDefinitionBuilder attributeDefn = BeanDefinitionBuilder.genericBeanDefinition(IdPAttribute.class);
            attributeDefn.addConstructorArgValue((Object)attrId);
            List values = ElementSupport.getChildElementsByTagNameNS((Node)child, (String)"urn:mace:shibboleth:2.0:resolver:dc", (String)"Value");
            ManagedList inValues = new ManagedList(values.size());
            for (Element val : values) {
                BeanDefinitionBuilder value = BeanDefinitionBuilder.genericBeanDefinition(StringAttributeValue.class);
                value.addConstructorArgValue((Object)val.getTextContent());
                this.log.trace("{} Attribute: {}, adding value {} ", new Object[]{this.getLogPrefix(), attrId, val.getTextContent()});
                inValues.add((Object)value.getBeanDefinition());
            }
            attributeDefn.addPropertyValue("values", (Object)inValues);
            this.log.debug("{} Adding Attribute: {} with {} values", new Object[]{this.getLogPrefix(), attrId, values.size()});
            attributes.add(attributeDefn.getBeanDefinition());
        }
        builder.addPropertyValue("values", (Object)attributes);
    }
}

