/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc;

import javax.annotation.Nonnull;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.spring.dc.BaseComputedIDDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.ManagedConnectionParser;
import net.shibboleth.idp.saml.attribute.resolver.impl.StoredIDDataConnector;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class StoredIDDataConnectorParser
extends BaseComputedIDDataConnectorParser {
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver:dc", "StoredId");
    private final Logger log = LoggerFactory.getLogger(StoredIDDataConnectorParser.class);

    protected Class<StoredIDDataConnector> getBeanClass(Element element) {
        return StoredIDDataConnector.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder, "storedId");
        this.log.debug("doParse {}", (Object)config);
        String springResources = AttributeSupport.getAttributeValue((Element)config, (QName)new QName("springResources"));
        if (springResources == null) {
            builder.addPropertyValue("dataSource", (Object)this.getv2DataSource(config));
        } else {
            builder.addPropertyValue("dataSource", (Object)this.getDataSource(springResources.split(";")));
        }
        if (config.hasAttributeNS(null, "queryTimeout")) {
            builder.addPropertyValue("queryTimeout", (Object)config.getAttributeNS(null, "queryTimeout"));
        }
    }

    protected DataSource getDataSource(String ... springResource) {
        BeanFactory beanFactory = this.createBeanFactory(springResource);
        return (DataSource)beanFactory.getBean(DataSource.class);
    }

    protected BeanDefinition getv2DataSource(@Nonnull Element config) {
        this.log.debug("parsing v2 configuration");
        ManagedConnectionParser parser = new ManagedConnectionParser(config);
        return parser.createDataSource();
    }
}

