/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.ldap;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.LDAPDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.TemplatedExecutableSearchFilterBuilder;
import net.shibboleth.idp.attribute.resolver.spring.dc.AbstractDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.CacheConfigParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.ldap.CredentialConfigFactoryBean;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.Credential;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.SearchExecutor;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchRequest;
import org.ldaptive.handler.CaseChangeEntryHandler;
import org.ldaptive.handler.MergeAttributeEntryHandler;
import org.ldaptive.handler.SearchEntryHandler;
import org.ldaptive.pool.BlockingConnectionPool;
import org.ldaptive.pool.IdlePruneStrategy;
import org.ldaptive.pool.PoolConfig;
import org.ldaptive.pool.PooledConnectionFactory;
import org.ldaptive.pool.SearchValidator;
import org.ldaptive.pool.SoftLimitConnectionPool;
import org.ldaptive.provider.ConnectionStrategy;
import org.ldaptive.sasl.Mechanism;
import org.ldaptive.sasl.SaslConfig;
import org.ldaptive.ssl.SslConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LDAPDataConnectorParser
extends AbstractDataConnectorParser {
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver:dc", "LDAPDirectory");
    public static final QName ATTRIBUTE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver:dc", "Attribute");
    private final Logger log = LoggerFactory.getLogger(LDAPDataConnectorParser.class);

    protected Class<LDAPDataConnector> getBeanClass(@Nullable Element element) {
        return LDAPDataConnector.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        this.log.debug("doParse {}", (Object)config);
        String springResources = AttributeSupport.getAttributeValue((Element)config, (QName)new QName("springResources"));
        if (springResources == null) {
            this.log.debug("parsing v2 configuration");
            this.doParseV2(config, parserContext, builder);
        } else {
            this.doParseInternal(config, this.createBeanFactory(springResources.split(";")), builder);
        }
    }

    protected void doParseInternal(@Nonnull Element config, @Nonnull BeanFactory beanFactory, @Nonnull BeanDefinitionBuilder builder) {
        this.addPropertyDescriptorValues(builder, beanFactory, LDAPDataConnector.class);
        String noResultAnError = AttributeSupport.getAttributeValue((Element)config, (QName)new QName("noResultIsError"));
        this.log.debug("parsed noResultAnError {}", (Object)noResultAnError);
        if (noResultAnError != null) {
            builder.addPropertyValue("noResultAnError", (Object)noResultAnError);
        }
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
    }

    protected void doParseV2(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        V2Parser v2Parser = new V2Parser(config);
        BeanDefinitionBuilder connectionFactory = BeanDefinitionBuilder.genericBeanDefinition(DefaultConnectionFactory.class);
        connectionFactory.addConstructorArgValue((Object)v2Parser.createConnectionConfig(parserContext));
        BeanDefinitionBuilder provider = BeanDefinitionBuilder.genericBeanDefinition(DefaultConnectionFactory.getDefaultProvider().getClass());
        BeanDefinitionBuilder providerConfig = BeanDefinitionBuilder.genericBeanDefinition(DefaultConnectionFactory.getDefaultProvider().getProviderConfig().getClass());
        String connectionStrategy = AttributeSupport.getAttributeValue((Element)config, (QName)new QName("connectionStrategy"));
        if (connectionStrategy == null) {
            providerConfig.addPropertyValue("connectionStrategy", (Object)ConnectionStrategy.ACTIVE_PASSIVE);
        } else {
            switch (connectionStrategy) {
                case "DEFAULT": {
                    providerConfig.addPropertyValue("connectionStrategy", (Object)ConnectionStrategy.DEFAULT);
                    break;
                }
                case "ROUND_ROBIN": {
                    providerConfig.addPropertyValue("connectionStrategy", (Object)ConnectionStrategy.ROUND_ROBIN);
                    break;
                }
                case "RANDOM": {
                    providerConfig.addPropertyValue("connectionStrategy", (Object)ConnectionStrategy.RANDOM);
                    break;
                }
                default: {
                    providerConfig.addPropertyValue("connectionStrategy", (Object)ConnectionStrategy.ACTIVE_PASSIVE);
                }
            }
        }
        ManagedMap props = new ManagedMap();
        List propertyElements = ElementSupport.getChildElements((Node)config, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "LDAPProperty"));
        for (Element e : propertyElements) {
            props.put((Object)AttributeSupport.getAttributeValue((Element)e, (QName)new QName("name")), (Object)AttributeSupport.getAttributeValue((Element)e, (QName)new QName("value")));
        }
        providerConfig.addPropertyValue("properties", (Object)props);
        provider.addPropertyValue("providerConfig", (Object)providerConfig.getBeanDefinition());
        connectionFactory.addPropertyValue("provider", (Object)provider.getBeanDefinition());
        builder.addPropertyValue("executableSearchBuilder", (Object)v2Parser.createTemplatedExecutableSearchFilterBuilder());
        BeanDefinition connectionPool = v2Parser.createConnectionPool((BeanDefinition)connectionFactory.getBeanDefinition());
        if (connectionPool != null) {
            BeanDefinitionBuilder pooledConnectionFactory = BeanDefinitionBuilder.genericBeanDefinition(PooledConnectionFactory.class);
            pooledConnectionFactory.addConstructorArgValue((Object)connectionPool);
            builder.addPropertyValue("connectionFactory", (Object)pooledConnectionFactory.getBeanDefinition());
        } else {
            builder.addPropertyValue("connectionFactory", (Object)connectionFactory.getBeanDefinition());
        }
        BeanDefinition searchExecutor = v2Parser.createSearchExecutor();
        builder.addPropertyValue("searchExecutor", (Object)searchExecutor);
        builder.addPropertyValue("resultsCache", (Object)v2Parser.createCache());
        String noResultIsError = AttributeSupport.getAttributeValue((Element)config, (QName)new QName("noResultIsError"));
        if (noResultIsError != null) {
            builder.addPropertyValue("noResultAnError", (Object)noResultIsError);
        }
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
    }

    protected static class V2Parser {
        private final Element configElement;
        private final Logger log = LoggerFactory.getLogger(V2Parser.class);

        public V2Parser(@Nonnull Element config) {
            Constraint.isNotNull((Object)config, (String)"LDAPDirectory element cannot be null");
            this.configElement = config;
        }

        @Nonnull
        public BeanDefinition createConnectionConfig(@Nonnull ParserContext parserContext) {
            Mechanism mechanism;
            String url = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("ldapURL"));
            String useStartTLS = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("useStartTLS"));
            String principal = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("principal"));
            String principalCredential = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("principalCredential"));
            String authenticationType = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("authenticationType"));
            BeanDefinitionBuilder connectionConfig = BeanDefinitionBuilder.genericBeanDefinition(ConnectionConfig.class);
            connectionConfig.addPropertyValue("ldapUrl", (Object)url);
            if (useStartTLS != null) {
                connectionConfig.addPropertyValue("useStartTLS", (Object)useStartTLS);
            }
            BeanDefinitionBuilder sslConfig = BeanDefinitionBuilder.genericBeanDefinition(SslConfig.class);
            sslConfig.addPropertyValue("credentialConfig", (Object)this.createCredentialConfig(parserContext));
            connectionConfig.addPropertyValue("sslConfig", (Object)sslConfig.getBeanDefinition());
            BeanDefinitionBuilder connectionInitializer = BeanDefinitionBuilder.genericBeanDefinition(BindConnectionInitializer.class);
            if (principal != null) {
                connectionInitializer.addPropertyValue("bindDn", (Object)principal);
            }
            if (principalCredential != null) {
                BeanDefinitionBuilder credential = BeanDefinitionBuilder.genericBeanDefinition(Credential.class);
                credential.addConstructorArgValue((Object)principalCredential);
                connectionInitializer.addPropertyValue("bindCredential", (Object)credential.getBeanDefinition());
            }
            if (authenticationType != null && (mechanism = Mechanism.valueOf((String)authenticationType)) != null) {
                SaslConfig config = new SaslConfig();
                config.setMechanism(mechanism);
                connectionInitializer.addPropertyValue("bindSaslConfig", (Object)config);
            }
            if (principal != null || principalCredential != null || authenticationType != null) {
                connectionConfig.addPropertyValue("connectionInitializer", (Object)connectionInitializer.getBeanDefinition());
            }
            return connectionConfig.getBeanDefinition();
        }

        @Nonnull
        protected BeanDefinition createCredentialConfig(@Nonnull ParserContext parserContext) {
            List authElements;
            BeanDefinitionBuilder result = BeanDefinitionBuilder.genericBeanDefinition(CredentialConfigFactoryBean.class);
            List trustElements = ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "StartTLSTrustCredential"));
            if (trustElements != null && !trustElements.isEmpty()) {
                if (trustElements.size() > 1) {
                    this.log.warn("Too many StartTLSTrustCredential elements in {}; only the first has been consulted", (Object)parserContext.getReaderContext().getResource().getDescription());
                }
                result.addPropertyValue("trustCredential", SpringSupport.parseCustomElements((Collection)trustElements, (ParserContext)parserContext).get(0));
            }
            if ((authElements = ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "StartTLSAuthenticationCredential"))) != null && !authElements.isEmpty()) {
                if (authElements.size() > 1) {
                    this.log.warn("Too many StartTLSAuthenticationCredential elements in {}; only the first has been consulted", (Object)parserContext.getReaderContext().getResource().getDescription());
                }
                result.addPropertyValue("authCredential", SpringSupport.parseCustomElements((Collection)authElements, (ParserContext)parserContext).get(0));
            }
            return result.getBeanDefinition();
        }

        @Nonnull
        public BeanDefinition createTemplatedExecutableSearchFilterBuilder() {
            BeanDefinitionBuilder templateBuilder = BeanDefinitionBuilder.genericBeanDefinition(TemplatedExecutableSearchFilterBuilder.class);
            templateBuilder.setInitMethodName("initialize");
            String velocityEngineRef = StringSupport.trimOrNull((String)this.configElement.getAttribute("templateEngine"));
            if (null == velocityEngineRef) {
                velocityEngineRef = "shibboleth.VelocityEngine";
            }
            templateBuilder.addPropertyReference("velocityEngine", velocityEngineRef);
            templateBuilder.addPropertyValue("v2Compatibility", (Object)true);
            String filter = null;
            Element filterElement = ElementSupport.getFirstChildElement((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "FilterTemplate"));
            if (filterElement != null) {
                filter = StringSupport.trimOrNull((String)filterElement.getTextContent().trim());
            }
            templateBuilder.addPropertyValue("templateText", filter);
            return templateBuilder.getBeanDefinition();
        }

        @Nonnull
        public BeanDefinition createSearchExecutor() {
            Element filterElement;
            String baseDn = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("baseDN"));
            String searchScope = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("searchScope"));
            String searchTimeLimit = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("searchTimeLimit"));
            String maxResultSize = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("maxResultSize"));
            String mergeResults = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("mergeResults"));
            String lowercaseAttributeNames = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("lowercaseAttributeNames"));
            BeanDefinitionBuilder searchExecutor = BeanDefinitionBuilder.genericBeanDefinition(SearchExecutor.class);
            searchExecutor.addPropertyValue("baseDn", (Object)baseDn);
            if (searchScope != null) {
                searchExecutor.addPropertyValue("searchScope", (Object)searchScope);
            }
            if (searchTimeLimit != null) {
                searchExecutor.addPropertyValue("timeLimit", (Object)searchTimeLimit);
            } else {
                searchExecutor.addPropertyValue("timeLimit", (Object)3000);
            }
            if (maxResultSize != null) {
                searchExecutor.addPropertyValue("sizeLimit", (Object)maxResultSize);
            } else {
                searchExecutor.addPropertyValue("sizeLimit", (Object)1);
            }
            BeanDefinitionBuilder handlers = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildSearchEntryHandlers");
            handlers.addConstructorArgValue((Object)mergeResults);
            handlers.addConstructorArgValue((Object)lowercaseAttributeNames);
            searchExecutor.addPropertyValue("searchEntryHandlers", (Object)handlers.getBeanDefinition());
            List returnAttrs = null;
            Element returnAttrsElement = ElementSupport.getFirstChildElement((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "ReturnAttributes"));
            if (returnAttrsElement != null && (returnAttrs = ElementSupport.getElementContentAsList((Element)returnAttrsElement)) != null && !returnAttrs.isEmpty()) {
                searchExecutor.addPropertyValue("returnAttributes", (Object)returnAttrs);
            }
            if ((filterElement = ElementSupport.getFirstChildElement((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "FilterTemplate"))) != null) {
                BeanDefinitionBuilder searchFilter = BeanDefinitionBuilder.genericBeanDefinition(SearchFilter.class);
                searchFilter.addConstructorArgValue((Object)filterElement.getTextContent().trim());
                searchExecutor.addPropertyValue("searchFilter", (Object)searchFilter.getBeanDefinition());
            }
            return searchExecutor.getBeanDefinition();
        }

        @Nullable
        public BeanDefinition createConnectionPool(BeanDefinition connectionFactory) {
            Element poolConfigElement = ElementSupport.getFirstChildElement((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "ConnectionPool"));
            if (poolConfigElement == null) {
                return null;
            }
            String blockWaitTime = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("blockWaitTime"));
            String expirationTime = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("expirationTime"));
            BeanDefinitionBuilder pool = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildConnectionPool");
            pool.addConstructorArgValue((Object)AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("blockWhenEmpty")));
            if (blockWaitTime != null) {
                BeanDefinitionBuilder duration = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildDuration");
                duration.addConstructorArgValue((Object)blockWaitTime);
                duration.addConstructorArgValue((Object)1);
                pool.addPropertyValue("blockWaitTime", (Object)duration.getBeanDefinition());
            }
            if (expirationTime != null) {
                BeanDefinitionBuilder period = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildDuration");
                period.addConstructorArgValue((Object)expirationTime);
                period.addConstructorArgValue((Object)2000);
                BeanDefinitionBuilder idle = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildDuration");
                idle.addConstructorArgValue((Object)expirationTime);
                idle.addConstructorArgValue((Object)1000);
                BeanDefinitionBuilder strategy = BeanDefinitionBuilder.genericBeanDefinition(IdlePruneStrategy.class);
                strategy.addConstructorArgValue((Object)period.getBeanDefinition());
                strategy.addConstructorArgValue((Object)idle.getBeanDefinition());
                pool.addPropertyValue("pruneStrategy", (Object)strategy.getBeanDefinition());
            }
            pool.addPropertyValue("poolConfig", (Object)this.createPoolConfig());
            String validateDN = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("validateDN"));
            String validateFilter = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("validateFilter"));
            BeanDefinitionBuilder searchRequest = BeanDefinitionBuilder.genericBeanDefinition(SearchRequest.class);
            if (validateDN != null) {
                searchRequest.addPropertyValue("baseDn", (Object)validateDN);
            }
            if (validateFilter != null) {
                BeanDefinitionBuilder searchFilter = BeanDefinitionBuilder.genericBeanDefinition(SearchFilter.class);
                searchFilter.addConstructorArgValue((Object)validateFilter);
                searchRequest.addPropertyValue("searchFilter", (Object)searchFilter.getBeanDefinition());
            }
            BeanDefinitionBuilder validator = BeanDefinitionBuilder.genericBeanDefinition(SearchValidator.class);
            validator.addPropertyValue("searchRequest", (Object)searchRequest.getBeanDefinition());
            pool.addPropertyValue("validator", (Object)validator.getBeanDefinition());
            pool.addPropertyValue("connectionFactory", (Object)connectionFactory);
            pool.setInitMethodName("initialize");
            return pool.getBeanDefinition();
        }

        @Nullable
        protected BeanDefinition createPoolConfig() {
            Element poolConfigElement = ElementSupport.getFirstChildElement((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "ConnectionPool"));
            if (poolConfigElement == null) {
                return null;
            }
            String minPoolSize = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("minPoolSize"));
            String maxPoolSize = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("maxPoolSize"));
            String validatePeriodically = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("validatePeriodically"));
            String validateTimerPeriod = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("validateTimerPeriod"));
            BeanDefinitionBuilder poolConfig = BeanDefinitionBuilder.genericBeanDefinition(PoolConfig.class);
            if (minPoolSize == null) {
                String poolInitialSize = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("poolInitialSize"));
                if (poolInitialSize != null) {
                    poolConfig.addPropertyValue("minPoolSize", (Object)poolInitialSize);
                } else {
                    poolConfig.addPropertyValue("minPoolSize", (Object)0);
                }
            } else {
                poolConfig.addPropertyValue("minPoolSize", (Object)minPoolSize);
            }
            if (maxPoolSize == null) {
                String poolMaxIdleSize = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("poolMaxIdleSize"));
                if (poolMaxIdleSize != null) {
                    poolConfig.addPropertyValue("maxPoolSize", (Object)poolMaxIdleSize);
                } else {
                    poolConfig.addPropertyValue("maxPoolSize", (Object)3);
                }
            } else {
                poolConfig.addPropertyValue("maxPoolSize", (Object)maxPoolSize);
            }
            if (validatePeriodically != null) {
                poolConfig.addPropertyValue("validatePeriodically", (Object)validatePeriodically);
            }
            if (validateTimerPeriod != null) {
                BeanDefinitionBuilder period = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildDuration");
                period.addConstructorArgValue((Object)validateTimerPeriod);
                period.addConstructorArgValue((Object)1000);
                poolConfig.addPropertyValue("validatePeriod", (Object)period.getBeanDefinition());
            } else {
                poolConfig.addPropertyValue("validatePeriod", (Object)1800);
            }
            return poolConfig.getBeanDefinition();
        }

        @Nullable
        public BeanDefinition createCache() {
            CacheConfigParser parser = new CacheConfigParser(this.configElement);
            return parser.createCache();
        }

        public static long buildDuration(String duration, long divisor) {
            return DOMTypeSupport.durationToLong((String)duration) / divisor;
        }

        public static BlockingConnectionPool buildConnectionPool(String blockWhenEmpty) {
            Object pool = null;
            pool = blockWhenEmpty == null || Boolean.valueOf(blockWhenEmpty) != false ? new BlockingConnectionPool() : new SoftLimitConnectionPool();
            return pool;
        }

        public static List<SearchEntryHandler> buildSearchEntryHandlers(String mergeResults, String lowercaseAttributeNames) {
            ArrayList handlers = Lists.newArrayList();
            if (Boolean.valueOf(mergeResults).booleanValue()) {
                handlers.add(new MergeAttributeEntryHandler());
            }
            if (Boolean.valueOf(lowercaseAttributeNames).booleanValue()) {
                CaseChangeEntryHandler entryHandler = new CaseChangeEntryHandler();
                entryHandler.setAttributeNameCaseChange(CaseChangeEntryHandler.CaseChange.LOWER);
                handlers.add(entryHandler);
            }
            return handlers;
        }
    }
}

