/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.rdbms;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.RDBMSDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.TemplatedExecutableStatementBuilder;
import net.shibboleth.idp.attribute.resolver.spring.dc.AbstractDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.CacheConfigParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.ManagedConnectionParser;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RDBMSDataConnectorParser
extends AbstractDataConnectorParser {
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver:dc", "RelationalDatabase");
    public static final QName ATTRIBUTE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver:dc", "Attribute");
    private final Logger log = LoggerFactory.getLogger(RDBMSDataConnectorParser.class);

    protected Class<RDBMSDataConnector> getBeanClass(@Nullable Element element) {
        return RDBMSDataConnector.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        this.log.debug("doParse {}", (Object)config);
        String springResources = AttributeSupport.getAttributeValue((Element)config, (QName)new QName("springResources"));
        if (springResources == null) {
            this.log.debug("parsing v2 configuration");
            this.doParseV2(config, parserContext, builder);
        } else {
            this.doParseInternal(config, this.createBeanFactory(springResources.split(";")), builder);
        }
    }

    protected void doParseInternal(@Nonnull Element config, @Nonnull BeanFactory beanFactory, @Nonnull BeanDefinitionBuilder builder) {
        this.addPropertyDescriptorValues(builder, beanFactory, RDBMSDataConnector.class);
        if (config.hasAttributeNS(null, "noResultIsError")) {
            String noResultAnError = config.getAttributeNS(null, "noResultIsError");
            this.log.debug("parsed noResultAnError {}", (Object)noResultAnError);
            builder.addPropertyValue("noResultAnError", (Object)noResultAnError);
        }
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
    }

    protected void doParseV2(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        V2Parser v2Parser = new V2Parser(config);
        builder.addPropertyValue("DataSource", (Object)v2Parser.createDataSource());
        builder.addPropertyValue("executableSearchBuilder", (Object)v2Parser.createTemplateBuilder());
        builder.addPropertyValue("resultsCache", (Object)v2Parser.createCache());
        String noResultIsError = AttributeSupport.getAttributeValue((Element)config, (QName)new QName("noResultIsError"));
        if (noResultIsError != null) {
            builder.addPropertyValue("noResultAnError", (Object)noResultIsError);
        }
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
    }

    protected static class V2Parser {
        private final Element configElement;

        public V2Parser(@Nonnull Element config) {
            Constraint.isNotNull((Object)config, (String)"RelationalDatabase element cannot be null");
            this.configElement = config;
        }

        @Nonnull
        public BeanDefinition createDataSource() {
            ManagedConnectionParser parser = new ManagedConnectionParser(this.configElement);
            return parser.createDataSource();
        }

        @Nonnull
        public BeanDefinition createTemplateBuilder() {
            BeanDefinitionBuilder templateBuilder = BeanDefinitionBuilder.genericBeanDefinition(TemplatedExecutableStatementBuilder.class);
            templateBuilder.setInitMethodName("initialize");
            templateBuilder.setDestroyMethodName("destroy");
            String velocityEngineRef = StringSupport.trimOrNull((String)this.configElement.getAttribute("templateEngine"));
            if (null == velocityEngineRef) {
                velocityEngineRef = "shibboleth.VelocityEngine";
            }
            templateBuilder.addPropertyReference("velocityEngine", velocityEngineRef);
            templateBuilder.addPropertyValue("v2Compatibility", (Object)true);
            String queryTimeout = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("queryTimeout"));
            if (queryTimeout != null) {
                BeanDefinitionBuilder duration = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildDuration");
                duration.addConstructorArgValue((Object)queryTimeout);
                duration.addConstructorArgValue((Object)1);
                templateBuilder.addPropertyValue("queryTimeout", (Object)duration.getBeanDefinition());
            } else {
                templateBuilder.addPropertyValue("queryTimeout", (Object)5000);
            }
            Element queryTemplate = ElementSupport.getFirstChildElement((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "QueryTemplate"));
            String queryText = queryTemplate.getTextContent();
            templateBuilder.addPropertyValue("templateText", (Object)queryText);
            templateBuilder.setInitMethodName("initialize");
            templateBuilder.setDestroyMethodName("destroy");
            return templateBuilder.getBeanDefinition();
        }

        @Nullable
        public BeanDefinition createCache() {
            CacheConfigParser parser = new CacheConfigParser(this.configElement);
            return parser.createCache();
        }

        public static long buildDuration(String duration, long divisor) {
            return DOMTypeSupport.durationToLong((String)duration) / divisor;
        }
    }
}

