/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.enc;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.spring.enc.BaseAttributeEncoderParser;
import net.shibboleth.idp.saml.attribute.encoding.impl.SAML2XMLObjectAttributeEncoder;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SAML2XMLObjectAttributeEncoderParser
extends BaseAttributeEncoderParser {
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:attribute:encoder", "SAML2XMLObject");
    public static final String NAME_FORMAT_ATTRIBUTE_NAME = "nameFormat";
    public static final String FRIENDLY_NAME_ATTRIBUTE_NAME = "friendlyName";

    public SAML2XMLObjectAttributeEncoderParser() {
        this.setNameRequired(true);
    }

    protected Class<SAML2XMLObjectAttributeEncoder> getBeanClass(@Nullable Element element) {
        return SAML2XMLObjectAttributeEncoder.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        String nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";
        if (config.hasAttributeNS(null, NAME_FORMAT_ATTRIBUTE_NAME)) {
            nameFormat = StringSupport.trimOrNull((String)config.getAttributeNS(null, NAME_FORMAT_ATTRIBUTE_NAME));
        }
        builder.addPropertyValue(NAME_FORMAT_ATTRIBUTE_NAME, (Object)nameFormat);
        builder.addPropertyValue(FRIENDLY_NAME_ATTRIBUTE_NAME, (Object)config.getAttribute(FRIENDLY_NAME_ATTRIBUTE_NAME));
    }
}

