/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring;

import com.google.common.base.Function;
import java.util.Collection;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.LegacyPrincipalDecoder;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImpl;
import net.shibboleth.idp.saml.attribute.principalconnector.impl.PrincipalConnector;
import net.shibboleth.idp.saml.attribute.principalconnector.impl.PrinicpalConnectorCanonicalizer;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.service.ServiceException;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class AttributeResolverServiceStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<ApplicationContext, ServiceableComponent<AttributeResolver>> {
    private final Logger log = LoggerFactory.getLogger(AttributeResolverServiceStrategy.class);

    @Nullable
    public ServiceableComponent<AttributeResolver> apply(@Nullable ApplicationContext appContext) {
        Collection pcs = appContext.getBeansOfType(PrincipalConnector.class).values();
        PrinicpalConnectorCanonicalizer pcc = new PrinicpalConnectorCanonicalizer(pcs);
        Collection definitions = appContext.getBeansOfType(AttributeDefinition.class).values();
        Collection connectors = appContext.getBeansOfType(DataConnector.class).values();
        this.log.debug("Creating Attribute Resolver {} with {} Attribute Definition(s), {} Data Connector(s) and {} Principal Connector(s)", new Object[]{this.getId(), definitions.size(), connectors.size(), pcs.size()});
        AttributeResolverImpl resolver = new AttributeResolverImpl(this.getId(), definitions, connectors, (LegacyPrincipalDecoder)pcc);
        resolver.setApplicationContext(appContext);
        try {
            resolver.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new ServiceException("Unable to initialize attribute resolver for " + appContext.getDisplayName(), (Exception)((Object)e));
        }
        return resolver;
    }
}

