/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc;

import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.spring.BaseResolverPluginParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.DataConnectorFactoryBean;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractDataConnectorParser
extends BaseResolverPluginParser {
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "DataConnector");
    public static final String ATTR_SPRING_RESOURCE = "springResources";
    public static final String ATTR_SPRING_RESOURCE_REF = "springResourcesRef";
    public static final String ATTR_FACTORY_POSTPROCESSORS_REF = "factoryPostProcessorsRef";
    public static final String ATTR_POSTPROCESSORS_REF = "postProcessorsRef";
    public static final QName FAILOVER_DATA_CONNECTOR_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "FailoverDataConnector");
    private final Logger log = LoggerFactory.getLogger(AbstractDataConnectorParser.class);

    protected boolean isNative(@Nonnull Element config) {
        return config.hasAttributeNS(null, ATTR_SPRING_RESOURCE) || config.hasAttributeNS(null, ATTR_SPRING_RESOURCE_REF);
    }

    protected final Class<?> getBeanClass(Element element) {
        if (this.isNative(element)) {
            return DataConnectorFactoryBean.class;
        }
        return this.getNativeBeanClass();
    }

    protected abstract Class<? extends AbstractDataConnector> getNativeBeanClass();

    @Override
    protected final void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        List failoverConnector = ElementSupport.getChildElements((Node)config, (QName)FAILOVER_DATA_CONNECTOR_ELEMENT_NAME);
        if (failoverConnector != null && !failoverConnector.isEmpty()) {
            String connectorId = StringSupport.trimOrNull((String)((Element)failoverConnector.get(0)).getAttributeNS(null, "ref"));
            this.log.debug("{} setting the following failover data connector dependencies {}", (Object)this.getLogPrefix(), (Object)connectorId);
            builder.addPropertyValue("failoverDataConnectorId", (Object)connectorId);
        }
        if (this.isNative(config)) {
            builder.addConstructorArgValue(this.getNativeBeanClass());
            builder.setInitMethodName(null);
            builder.setDestroyMethodName(null);
            if (config.hasAttributeNS(null, ATTR_SPRING_RESOURCE)) {
                String[] resources = config.getAttributeNS(null, ATTR_SPRING_RESOURCE).split(";");
                this.log.debug("{} native configuration from {}", (Object)this.getLogPrefix(), (Object)resources);
                builder.addPropertyValue("resources", (Object)resources);
            } else {
                String resourceRef = config.getAttributeNS(null, ATTR_SPRING_RESOURCE_REF);
                this.log.debug("{} native configuration from bean {}", (Object)this.getLogPrefix(), (Object)resourceRef);
                builder.addPropertyReference("resources", resourceRef);
            }
            if (config.hasAttribute(ATTR_FACTORY_POSTPROCESSORS_REF)) {
                String factoryPostProcessorsRef = config.getAttributeNS(null, ATTR_FACTORY_POSTPROCESSORS_REF);
                this.log.debug("{} Factory Bean Post Processors {}", (Object)this.getLogPrefix(), (Object)factoryPostProcessorsRef);
                builder.addPropertyReference("beanFactoryPostProcessors", factoryPostProcessorsRef);
            } else {
                this.log.debug("{} Adding default Factory Bean Post Processors shibboleth.PropertySourcesPlaceholderConfigurer", (Object)this.getLogPrefix());
                builder.addPropertyReference("beanFactoryPostProcessors", "shibboleth.PropertySourcesPlaceholderConfigurer");
            }
            if (config.hasAttribute(ATTR_POSTPROCESSORS_REF)) {
                String postProcessorsRef = config.getAttributeNS(null, ATTR_POSTPROCESSORS_REF);
                this.log.debug("{} Bean Post Processors {}", (Object)this.getLogPrefix(), (Object)postProcessorsRef);
                builder.addPropertyReference("beanPostProcessors", postProcessorsRef);
            }
        } else {
            this.doV2Parse(config, parserContext, builder);
        }
    }

    protected abstract void doV2Parse(Element var1, ParserContext var2, BeanDefinitionBuilder var3);

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        StringBuilder builder = new StringBuilder("Data Connector '").append(this.getDefinitionId()).append("':");
        return builder.toString();
    }
}

