/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CacheConfigParser {
    private final Logger log = LoggerFactory.getLogger(CacheConfigParser.class);
    private final Element configElement;

    public CacheConfigParser(@Nonnull Element config) {
        Constraint.isNotNull((Object)config, (String)"Element cannot be null");
        this.configElement = config;
    }

    @Nonnull
    public BeanDefinition createCache() {
        String defaultCache = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("cacheResults"));
        if (defaultCache != null) {
            this.log.warn("The cacheResults attribute is no longer supported, please create a dc:ResultCache element");
            return null;
        }
        Element cacheElement = ElementSupport.getFirstChildElement((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "ResultCache"));
        if (cacheElement == null) {
            return null;
        }
        BeanDefinitionBuilder cache = BeanDefinitionBuilder.rootBeanDefinition(CacheConfigParser.class, (String)"buildCache");
        cache.addConstructorArgValue((Object)AttributeSupport.getAttributeValue((Element)cacheElement, (QName)new QName("elementTimeToLive")));
        cache.addConstructorArgValue((Object)AttributeSupport.getAttributeValue((Element)cacheElement, (QName)new QName("maximumCachedElements")));
        return cache.getBeanDefinition();
    }

    @Nullable
    public static Cache<String, Map<String, IdPAttribute>> buildCache(@Nullable String timeToLive, @Nullable String maximumSize) {
        return CacheBuilder.newBuilder().maximumSize(maximumSize != null ? Long.parseLong(maximumSize) : 500L).expireAfterAccess(timeToLive != null ? DOMTypeSupport.durationToLong((String)timeToLive) : 14400000L, TimeUnit.MILLISECONDS).build();
    }
}

