/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ManagedConnectionParser {
    private final Element configElement;

    public ManagedConnectionParser(@Nonnull Element config) {
        Constraint.isNotNull((Object)config, (String)"Element cannot be null");
        this.configElement = config;
    }

    @Nullable
    public BeanDefinition createDataSource() {
        Element containerManagedElement = ElementSupport.getFirstChildElement((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "ContainerManagedConnection"));
        if (containerManagedElement != null) {
            return this.createContainerManagedDataSource(containerManagedElement);
        }
        Element applicationManagedElement = ElementSupport.getFirstChildElement((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "ApplicationManagedConnection"));
        if (applicationManagedElement != null) {
            return this.createApplicationManagedDataSource(applicationManagedElement);
        }
        return null;
    }

    @Nonnull
    protected BeanDefinition createContainerManagedDataSource(@Nonnull Element containerManagedElement) {
        Constraint.isNotNull((Object)containerManagedElement, (String)"ContainerManagedConnection element cannot be null");
        String resourceName = AttributeSupport.getAttributeValue((Element)containerManagedElement, (QName)new QName("resourceName"));
        ManagedMap props = new ManagedMap();
        Element propertyElement = ElementSupport.getFirstChildElement((Node)containerManagedElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver:dc", "JNDIConnectionProperty"));
        List elements = ElementSupport.getChildElements((Node)propertyElement);
        for (Element e : elements) {
            props.put((Object)AttributeSupport.getAttributeValue((Element)e, (QName)new QName("name")), (Object)AttributeSupport.getAttributeValue((Element)e, (QName)new QName("value")));
        }
        BeanDefinitionBuilder dataSource = BeanDefinitionBuilder.rootBeanDefinition(ManagedConnectionParser.class, (String)"buildDataSource");
        dataSource.addConstructorArgValue((Object)props);
        dataSource.addConstructorArgValue((Object)resourceName);
        return dataSource.getBeanDefinition();
    }

    @Nonnull
    protected BeanDefinition createApplicationManagedDataSource(@Nonnull Element applicationManagedElement) {
        Constraint.isNotNull((Object)applicationManagedElement, (String)"ApplicationManagedConnection element cannot be null");
        BeanDefinitionBuilder dataSource = BeanDefinitionBuilder.genericBeanDefinition(ComboPooledDataSource.class);
        BeanDefinitionBuilder jdbcDriver = BeanDefinitionBuilder.rootBeanDefinition(ManagedConnectionParser.class, (String)"loadJdbcDriver");
        jdbcDriver.addConstructorArgValue((Object)AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("jdbcDriver")));
        dataSource.addPropertyValue("driverClass", (Object)jdbcDriver.getBeanDefinition());
        dataSource.addPropertyValue("jdbcUrl", (Object)AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("jdbcURL")));
        dataSource.addPropertyValue("user", (Object)AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("jdbcUserName")));
        dataSource.addPropertyValue("password", (Object)AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("jdbcPassword")));
        String poolAcquireIncrement = AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("poolAcquireIncrement"));
        if (poolAcquireIncrement != null) {
            dataSource.addPropertyValue("acquireIncrement", (Object)poolAcquireIncrement);
        } else {
            dataSource.addPropertyValue("acquireIncrement", (Object)3);
        }
        String poolAcquireRetryAttempts = AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("poolAcquireRetryAttempts"));
        if (poolAcquireRetryAttempts != null) {
            dataSource.addPropertyValue("acquireRetryAttempts", (Object)poolAcquireRetryAttempts);
        } else {
            dataSource.addPropertyValue("acquireRetryAttempts", (Object)36);
        }
        String poolAcquireRetryDelay = AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("poolAcquireRetryDelay"));
        if (poolAcquireRetryDelay != null) {
            dataSource.addPropertyValue("acquireRetryDelay", (Object)poolAcquireRetryDelay);
        } else {
            dataSource.addPropertyValue("acquireRetryDelay", (Object)5000);
        }
        String poolBreakAfterAcquireFailure = AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("poolBreakAfterAcquireFailure"));
        if (poolBreakAfterAcquireFailure != null) {
            dataSource.addPropertyValue("breakAfterAcquireFailure", (Object)poolBreakAfterAcquireFailure);
        } else {
            dataSource.addPropertyValue("breakAfterAcquireFailure", (Object)true);
        }
        String poolMinSize = AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("poolMinSize"));
        if (poolMinSize != null) {
            dataSource.addPropertyValue("minPoolSize", (Object)poolMinSize);
        } else {
            dataSource.addPropertyValue("minPoolSize", (Object)2);
        }
        String poolMaxSize = AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("poolMaxSize"));
        if (poolMaxSize != null) {
            dataSource.addPropertyValue("maxPoolSize", (Object)poolMaxSize);
        } else {
            dataSource.addPropertyValue("maxPoolSize", (Object)50);
        }
        String poolMaxIdleTime = AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("poolMaxIdleTime"));
        if (poolMaxIdleTime != null) {
            dataSource.addPropertyValue("maxIdleTime", (Object)poolMaxIdleTime);
        } else {
            dataSource.addPropertyValue("maxIdleTime", (Object)600);
        }
        String poolIdleTestPeriod = AttributeSupport.getAttributeValue((Element)applicationManagedElement, (QName)new QName("poolIdleTestPeriod"));
        if (poolIdleTestPeriod != null) {
            dataSource.addPropertyValue("idleConnectionTestPeriod", (Object)poolIdleTestPeriod);
        } else {
            dataSource.addPropertyValue("idleConnectionTestPeriod", (Object)180);
        }
        return dataSource.getBeanDefinition();
    }

    @Nullable
    public static DataSource buildDataSource(Map<String, String> props, String resourceName) {
        try {
            InitialContext initCtx = new InitialContext(new Hashtable<String, String>(props));
            DataSource dataSource = (DataSource)initCtx.lookup(resourceName);
            return dataSource;
        }
        catch (NamingException e) {
            Logger log = LoggerFactory.getLogger(ManagedConnectionParser.class);
            log.error("Managed data source '{}' could not be found", (Object)resourceName, (Object)e);
            return null;
        }
    }

    public static String loadJdbcDriver(String jdbcDriver) {
        ClassLoader classLoader = ManagedConnectionParser.class.getClassLoader();
        try {
            classLoader.loadClass(jdbcDriver);
        }
        catch (ClassNotFoundException e) {
            Logger log = LoggerFactory.getLogger(ManagedConnectionParser.class);
            log.error("JDBC driver '{}' could not be found", (Object)jdbcDriver, (Object)e);
        }
        return jdbcDriver;
    }
}

