/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.ldap;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import net.shibboleth.ext.spring.factory.AbstractComponentAwareFactoryBean;
import org.ldaptive.ssl.CredentialConfig;
import org.ldaptive.ssl.CredentialConfigFactory;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;

public class CredentialConfigFactoryBean
extends AbstractComponentAwareFactoryBean<CredentialConfig> {
    private static Logger log = LoggerFactory.getLogger(CredentialConfigFactoryBean.class);
    private Credential trustCredential;
    private Credential authCredential;

    public Class<?> getObjectType() {
        return CredentialConfig.class;
    }

    protected CredentialConfig doCreateInstance() throws Exception {
        X509Certificate[] trustCerts = null;
        if (this.trustCredential != null) {
            if (this.trustCredential instanceof X509Credential) {
                X509Credential cred = (X509Credential)this.trustCredential;
                trustCerts = cred.getEntityCertificateChain().toArray(new X509Certificate[cred.getEntityCertificateChain().size()]);
            } else {
                log.error("Supplied StartTLSTrustCredential was of type {}, not {}", (Object)this.trustCredential.getClass().getName(), (Object)X509Credential.class.getName());
                throw new BeanCreationException("Supplied StartTLSTrustCredential was of wrong type");
            }
        }
        X509Certificate authCert = null;
        PrivateKey authKey = null;
        if (this.authCredential != null) {
            if (this.authCredential instanceof X509Credential) {
                X509Credential cred = (X509Credential)this.authCredential;
                authCert = cred.getEntityCertificate();
                authKey = cred.getPrivateKey();
            } else {
                log.error("Supplied StartTLSAuthenticationCredential was of type {}, not {}", (Object)this.authCredential.getClass().getName(), (Object)X509Credential.class.getName());
                throw new BeanCreationException("Supplied StartTLSAuthenticationCredential was of wrong type");
            }
        }
        return CredentialConfigFactory.createX509CredentialConfig(trustCerts, authCert, authKey);
    }

    public Credential getAuthCredential() {
        return this.authCredential;
    }

    public void setAuthCredential(Credential credential) {
        this.authCredential = credential;
    }

    public Credential getTrustCredential() {
        return this.trustCredential;
    }

    public void setTrustCredential(Credential credential) {
        this.trustCredential = credential;
    }
}

