/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.spring.BaseResolverPluginParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.AbstractDataConnectorParser;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseComputedIDDataConnectorParser
extends BaseResolverPluginParser {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseComputedIDDataConnectorParser.class);

    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder, @Nullable String generatedIdDefaultName) {
        super.doParse(config, parserContext, builder);
        String generatedAttribute = config.hasAttributeNS(null, "generatedAttributeID") ? StringSupport.trimOrNull((String)config.getAttributeNS(null, "generatedAttributeID")) : generatedIdDefaultName;
        List failoverConnector = ElementSupport.getChildElements((Node)config, (QName)AbstractDataConnectorParser.FAILOVER_DATA_CONNECTOR_ELEMENT_NAME);
        if (failoverConnector != null && !failoverConnector.isEmpty()) {
            String connectorId = StringSupport.trimOrNull((String)((Element)failoverConnector.get(0)).getAttributeNS(null, "ref"));
            this.log.debug("{} Setting the following failover data connector dependencies: {}", (Object)this.getLogPrefix(), (Object)connectorId);
            builder.addPropertyValue("failoverDataConnectorId", (Object)connectorId);
        }
        String sourceAttribute = StringSupport.trimOrNull((String)config.getAttributeNS(null, "sourceAttributeID"));
        String salt = StringSupport.trimOrNull((String)config.getAttributeNS(null, "salt"));
        if (null == salt) {
            this.log.debug("{} Generated Attribute: '{}', sourceAttribute = '{}', no salt provided", new Object[]{this.getLogPrefix(), generatedAttribute, sourceAttribute});
        } else {
            this.log.debug("{} Generated Attribute: '{}', sourceAttribute = '{}', salt (or property): '{}'", new Object[]{this.getLogPrefix(), generatedAttribute, sourceAttribute, salt});
        }
        builder.addPropertyValue("generatedAttributeId", (Object)generatedAttribute);
        builder.addPropertyValue("sourceAttributeId", (Object)sourceAttribute);
        builder.addPropertyValue("salt", (Object)salt);
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        StringBuilder builder = new StringBuilder("Data Connector '").append(this.getDefinitionId()).append("':");
        return builder.toString();
    }
}

