/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.ad.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.spring.ad.BaseAttributeDefinitionParser;
import net.shibboleth.idp.saml.attribute.resolver.impl.TransientIdAttributeDefinition;
import net.shibboleth.idp.saml.nameid.impl.CryptoTransientIdGenerationStrategy;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class CryptoTransientIdAttributeDefinitionParser
extends BaseAttributeDefinitionParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver:ad", "CryptoTransientId");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CryptoTransientIdAttributeDefinitionParser.class);

    protected Class<TransientIdAttributeDefinition> getBeanClass(@Nullable Element element) {
        return TransientIdAttributeDefinition.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        BeanDefinitionBuilder strategyBuilder = BeanDefinitionBuilder.genericBeanDefinition(CryptoTransientIdGenerationStrategy.class);
        strategyBuilder.setInitMethodName("initialize");
        strategyBuilder.addPropertyValue("id", (Object)("CryptoTransientIdGenerationStrategy:" + this.getDefinitionId()));
        if (config.hasAttributeNS(null, "lifetime")) {
            strategyBuilder.addPropertyValue("idLifetime", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "lifetime")));
        }
        strategyBuilder.addPropertyReference("dataSealer", StringSupport.trimOrNull((String)config.getAttributeNS(null, "dataSealerRef")));
        builder.addConstructorArgValue((Object)strategyBuilder.getBeanDefinition());
        this.log.warn("{} This feature is DEPRECATED in favor of a TransientSAML2NameIDGenerator", (Object)this.getLogPrefix());
    }

    @Override
    protected boolean needsAttributeSourceID() {
        return false;
    }
}

